package LinkFuture.Core.ContentManager.Model;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */

import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import LinkFuture.Init.ObjectExtend.JAXBCaseInsensitiveMapAdaptor;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.List;

@XmlRootElement(name="ContentConfiguration")
@XmlSeeAlso({ResourceInfo.class,SecurityInfo.class,ParameterInfo.class,ContentItemInfo.class,ProcessorInfo.class,ContentImportFileInfo.class})
public class ContentConfigurationInfo
{
    @XmlElement(name="Import")
    public List<ContentImportFileInfo> ImportList;

    @XmlElementWrapper(name="ContentItemList")
    @XmlElement(name="ContentItem")
    public List<ContentItemInfo> ContentItemList;

    @XmlElement(name="SecurityList")
    @XmlJavaTypeAdapter(value=JAXBCaseInsensitiveMapAdaptor.class)
    public CaseInsensitiveMap<SecurityInfo>  SecurityList;

    @XmlElement(name="ParameterList")
    @XmlJavaTypeAdapter(value=JAXBCaseInsensitiveMapAdaptor.class)
    public CaseInsensitiveMap<ParameterInfo>  ParameterList;

    @XmlElement(name="ResourceList")
    @XmlJavaTypeAdapter(value=JAXBCaseInsensitiveMapAdaptor.class)
    public CaseInsensitiveMap<ResourceInfo> ResourceList;

    @XmlElement(name = "ProcessorList")
    @XmlJavaTypeAdapter(value=JAXBCaseInsensitiveMapAdaptor.class)
    public CaseInsensitiveMap<ProcessorInfo> ProcessorList;

    public Integer LatestVersion = Integer.MIN_VALUE;

    public ContentItemInfo FindContentItem(String name)  {
        return FindContentItem(name,null);
    }
    public ContentItemInfo FindContentItem(String name,Integer version)  {
        if(version!=null && version > this.LatestVersion)
        {
            throw new IllegalArgumentException("Specific version does not exist:" + version);
        }
        if(this.ContentItemList!=null)
        {
            ContentItemInfo latestVersion = null;
            ContentItemInfo closestVersion = null;
            for (ContentItemInfo item:this.ContentItemList)
            {
                if(item.Name.equalsIgnoreCase(name) && !item.Disabled)
                {
                    //if not specific version, we need find latest version
                    if(version==null)
                    {
                       if(latestVersion ==null || latestVersion.Version<item.Version)
                       {
                           latestVersion = item;
                       }
                    }
                    else
                    {
                        //get specific version
                        if(item.Version.equals(version))
                        {
                            return item;
                        }
                        //get closest version
                        if(item.Version < version)
                        {
                            if(closestVersion==null || version - closestVersion.Version > version - item.Version)
                            {
                                closestVersion = item;
                            }
                        }
                    }
                }
            }
            if(version==null && latestVersion!=null)
            {
                return latestVersion;
            }
            if(closestVersion!=null)
            {
                return closestVersion;
            }
        }
        throw new IllegalArgumentException("Specific content item not found:" + name);
    }
}
