package LinkFuture.Core.ContentManager.ContentValidator;

import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ValidatorInfo;
import LinkFuture.Init.Extensions.StringExtension;
import java.util.regex.Pattern;

/**
 * User: Cyokin Zhang
 * Date: 10/29/13
 * Time: 10:00 PM
 */
public class InputParameterValidator extends ContentBeanBaseValidator<InputParameterListMetaInfo>  {
    public InputParameterValidator(ContentItemInfo content, ValidatorInfo CurrentValidator) throws Exception {
        super(content, CurrentValidator, InputParameterListMetaInfo.class);
    }

    @Override
    public void Valid(ContentParameterCollectionInfo parameters) {
        if(this.Meta.ParameterList!=null && this.Meta.ParameterList.size()>0)
        {
            if (parameters == null)
            {
                throw new IllegalArgumentException("Parameter required");
            }
            for (InputParameterMetaInfo inputParameter :this.Meta.ParameterList)
            {
                if (parameters.containsKey(inputParameter.Name))
                {
                    String inputValue = parameters.get(inputParameter.Name).toString();
                    //if it is empty and it is required
                    if (StringExtension.IsNullOrEmpty(inputValue) && inputParameter.IsRequired)
                    {
                        throw new IllegalArgumentException(String.format("%s is required",inputParameter.Name));
                    }
                    if (!StringExtension.IsNullOrEmpty(inputParameter.Validation))
                    {
                        Pattern p = Pattern.compile(inputParameter.Validation,Pattern.CASE_INSENSITIVE);
                        if (p.matcher(inputValue).matches())
                        {
                            continue;
                        }
                        else
                        {
                            throwException(inputParameter);
                        }
                    }
                    else
                    {
                        //no validation
                        continue;
                    }
                }
                else
                {
                    //don't have it, use default value
                    if(!StringExtension.IsNullOrEmpty(inputParameter.DefaultValue))
                    {
                        parameters.put(inputParameter.Name,inputParameter.DefaultValue);
                        continue;
                    }
                    else
                    {
                        //otherwise if required, throw exception
                        if(inputParameter.IsRequired)
                        {
                            throw new IllegalArgumentException(String.format("%s is required",inputParameter.Name));
                        }
                    }
                }
            }
        }


    }
    private void throwException(InputParameterMetaInfo inputParameter ){
        throw new IllegalArgumentException(StringExtension.IsNullOrEmpty(inputParameter.ErrorMessage) ? inputParameter.Name : inputParameter.ErrorMessage);
    }
}
