package LinkFuture.Core.ContentManager.ContentSelector;

import LinkFuture.Core.ContentManager.Model.AddCycleType;
import LinkFuture.Core.ContentManager.Model.AddInfo;
import LinkFuture.Core.ContentManager.Model.AddParameterInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Config;
import LinkFuture.Init.Extensions.StringExtension;

/**
 * User: Cyokin Zhang
 * Date: 12/30/13
 * Time: 3:04 PM
 */
public class ContentSelectorController {
    public static void BuilderSelector(AddInfo add,ContentParameterCollectionInfo parameters,AddCycleType cycleType) throws Exception {
        if(add!=null && add.SelectorList!=null && add.SelectorList.size()>0)
        {
            for (AddParameterInfo item:add.SelectorList.values())
            {
                if(item.Cycle!=cycleType)
                {
                    break;
                }
                String itemKey = StringExtension.IsNullOrEmpty(item.OutName)?item.Name:item.OutName;

                if(StringExtension.IsNullOrEmpty(item.Value))
                {
                    //don;t have value use default value;
                    if(!StringExtension.IsNullOrEmpty(item.DefaultValue))
                    {
                        Debugger.LogFactory.trace("Get selector default value {} => {}",itemKey,item.DefaultValue);
                        parameters.put(itemKey,item.DefaultValue);
                        continue;
                    }
                    else
                    {
                        if(!item.IgnoreException)
                        {
                            throw new IllegalArgumentException("Can't find value for selector:" + item.Name);
                        }
                        continue;
                    }
                }
                else
                {
                    String[] keyList = StringExtension.FindReplacement(item.Value);
                    String itemValue = item.Value;
                    if(keyList!=null)
                    {
                        for (int i=0;i<keyList.length;i++)
                        {
                            String key = keyList[i];
                            Object replacement = null;
                            if(parameters.containsKey(key))
                            {
                                replacement = parameters.get(key);
                            }
                            else
                            {
                                replacement = parameters.getSelector("{".concat(key).concat("}"));
                            }
                            if(replacement!=null && !StringExtension.IsNullOrEmpty(replacement.toString()))
                            {
                                itemValue = StringExtension.ReplaceAll(itemValue,key,replacement.toString());
                            }
                            else
                            {
                                //can't find any replacement? and don't have default value? we have to throw exception if not ignored
                                if(!item.IgnoreException && StringExtension.IsNullOrEmpty(item.DefaultValue))
                                {
                                    throw new IllegalArgumentException(String.format("Can't find specific param(%s) for selector %s,",key,item.Name));
                                }
                                itemValue = StringExtension.ReplaceAll(itemValue,key, Config.Empty);
                            }
                        }
                    }
                    //can't find any replacement? use default value
                    if(StringExtension.IsNullOrEmpty(itemValue) && !StringExtension.IsNullOrEmpty(item.DefaultValue))
                    {
                        itemValue = item.DefaultValue;
                    }
                    Debugger.LogFactory.trace("Get selector value {} => {}", itemKey, itemValue);
                    parameters.put(item.Name,itemValue);
                }
            }
        }
    }
}
