package LinkFuture.Core.ContentManager.ContentSelector;

import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;

import java.util.concurrent.ConcurrentHashMap;

/**
 * User: Cyokin Zhang
 * Date: 12/3/13
 * Time: 1:17 PM
 */
public abstract class ContentBaseSelector implements IContentSelector {
    protected CaseInsensitiveMap<Object> currentParameters;
    protected ContentSelectorMeta meta;
    private String resourceIdentity;
    private ConcurrentHashMap<String,Object> cachedObject = new ConcurrentHashMap<>();
    public ContentBaseSelector(ContentParameterCollectionInfo parameters,ContentSelectorMeta meta)
    {
        //note:must use supper level, otherwise would be dead loop
        this.currentParameters = parameters;
        this.meta = meta;
    }
    @Override
    public Object Selector() throws Exception {
        String key = this.GetSelectorIdentity();
        if(!cachedObject.containsKey(key))
        {
            Object result = LoadSelector();
            if(result!=null)
            {
                Debugger.LogFactory.trace("Selector {} => {}",key,result);
                cachedObject.put(key,result);
            }
            else
            {
                return null;
            }
        }
        return cachedObject.get(key);
    }

    public abstract Object LoadSelector() throws Exception;

    @Override
    public String GetSelectorIdentity() throws Exception {
        if(StringExtension.IsNullOrEmpty(resourceIdentity))
        {
            this.resourceIdentity = BuildSelectorIdentity().toLowerCase();
        }
        return this.resourceIdentity;
    };

    public abstract String BuildSelectorIdentity() throws Exception;
}
