package LinkFuture.Core.ContentManager.ContentSecurity;

import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.SecurityInfo;
import LinkFuture.Init.Config;
import LinkFuture.Init.Debugger;

import javax.naming.NamingException;
import javax.xml.bind.DatatypeConverter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

/**
 * Created by Cyokin
 * on 3/23/2016.
 */
public class ContentBasicSecurity extends ContentBeanBaseSecurity<ContentBasicMetaInfo> {
    public ContentBasicSecurity(SecurityInfo currentSecurity) throws Exception {
        super(currentSecurity, ContentBasicMetaInfo.class);
    }

    @Override
    public void Verify(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        Debugger.LogFactory.trace("Basic Authorization");
        if(parameters.containsKey("LF_Authorization"))
        {
            try
            {
                String auth = (String)parameters.get("LF_Authorization");
                if(!allowUser(auth))
                {
                    //httpResponse.setHeader("WWW-Authenticate","Basic realm=\"LinkFuture Web Services\"");
                    Debugger.LogFactory.trace("Authorization token has been expired");
                    throw new SecurityException("Token has been expired");
                }
            }
            catch (Exception e)
            {
                Debugger.fatal("Authorization failed",e);
                throw new SecurityException("Authorization failed");
            }
        }
        else
        {
            Debugger.LogFactory.trace("Authorization failed");
            throw new SecurityException("Authorization failed");
        }
    }
    public boolean allowUser(String authHeader) throws UnsupportedEncodingException, NamingException {

        if (authHeader != null) {
            StringTokenizer st = new StringTokenizer(authHeader);
            if (st.hasMoreTokens()) {
                String basic = st.nextToken();
                // Only dealing with HTTP Basic authentication
                if (basic.equalsIgnoreCase("Basic")) {
                    String credentials = st.nextToken();
                    // Decode username and password.
                    // The decoded string is in the form:
                    // "userID:password".
                    String userPass = new String(DatatypeConverter.parseBase64Binary(credentials), Config.DefaultEncoding);
                    int separator = userPass.indexOf(":");
                    if (separator != -1) {
                        String inputUsername = userPass.substring(0, separator);
                        String inputPassword = userPass.substring(separator + 1);
                        return
                              this.Meta.UserName.equalsIgnoreCase(inputUsername)
                            && this.Meta.Password.equals(inputPassword);

                    }
                }
            }
        }
        return false;
    }
}
