package LinkFuture.Core.ContentManager.ContentResource;

import LinkFuture.Init.Extensions.StringExtension;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Created by Cyokin
 * on 7/1/2015.
 */
@XmlRootElement(name = "Meta")
public class GenericDBContentResourceMetaInfo {
    @XmlAttribute(name="ConnectionStringName")
    public String ConnectionStringName;

    @XmlAttribute(name="TableName")
    public String TableName;

    @XmlElement(name="Select")
    public DBActionInfo SelectAction;

    @XmlElement(name="Delete")
    public DBActionInfo DeleteAction;

    @XmlElement(name="Update")
    public DBActionInfo UpdateAction;

    @XmlElement(name="Insert")
    public DBActionInfo InsertAction;

    public boolean hasAction(DBActionInfo action){
        return action!=null && !StringExtension.IsNullOrEmpty(action.Action);
    }
    public boolean hasDefaultParameters(DBActionInfo action){
        return action!=null && action.DefaultParameters!=null && action.DefaultParameters.size()>0;
    }
}
