package LinkFuture.Core.ContentManager.ContentParameter;

import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ParameterInfo;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Extensions.PathExtension;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;

import java.util.Map;
import java.util.Properties;

/**
 * User: Cyokin Zhang
 * Date: 12/11/13
 * Time: 2:18 PM
 */
public class PropertiesParameter extends ContentBeanBaseParameter<PropertiesParameterMetaInfo> {

    public PropertiesParameter(ParameterInfo currentParameter) throws Exception {
        super(currentParameter,PropertiesParameterMetaInfo.class);
    }
    @Override
    public CaseInsensitiveMap<Object> GerResource(ContentParameterCollectionInfo parameters) throws Exception {
        String filePath = this.GetAbsolutePath(parameters);
        Properties file = Utility.ReadProperties(filePath);
        CaseInsensitiveMap<Object> passedParameters = new CaseInsensitiveMap<>();
        for (Map.Entry<Object,Object> item: file.entrySet())
        {
            passedParameters.put(item.getKey().toString(),item.getValue());
        }

        return passedParameters;
    }
    private String GetAbsolutePath(ContentParameterCollectionInfo parameters)
    {
        if(StringExtension.IsNullOrEmpty(this.Meta.RelativePath))
        {
            throw new IllegalArgumentException("PropertiesParameter file " + this.Meta.RelativePath + " can't not be empty");
        }
        return PathExtension.FullPhysicalPath(parameters.ParamReplace(this.Meta.RelativePath));
    }
    @Override
    public String GerParameterIdentity(ContentParameterCollectionInfo parameters) {
        return "$PropertiesParameter$".concat(this.GetAbsolutePath(parameters));
    }


}
