package LinkFuture.Core.ContentManager.ContentParameter;

import LinkFuture.Core.ContentManager.ContentController;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentType;
import LinkFuture.Core.ContentManager.Model.ParameterInfo;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import org.json.JSONObject;

import java.util.Iterator;

/**
 * Created by Cyokin
 * on 7/9/2015.
 */
public class JsonParameter extends ContentBaseParameter {
    public JsonParameter(ParameterInfo currentParameter) {
        super(currentParameter);
    }

    @Override
    public CaseInsensitiveMap<Object> GerResource(ContentParameterCollectionInfo parameters) throws Exception {
        CaseInsensitiveMap<Object> list = new CaseInsensitiveMap<>();
        if(parameters.containsKey(ContentController.LF_CONTENT_TYPE))
        {
            ContentType contentType = (ContentType)parameters.get(ContentController.LF_CONTENT_TYPE);
            if(contentType==ContentType.Json && parameters.containsKey(ContentController.LF_PLAY_LOAD))
            {
                String playLoad = ((String)parameters.get(ContentController.LF_PLAY_LOAD)).trim();
                if(playLoad.startsWith("{") && playLoad.endsWith("}"))
                {
                    JSONObject json = new JSONObject(playLoad);
                    Iterator<?> keys = json.keys();
                    while (keys.hasNext()){
                        String key = (String)keys.next();
                        list.put(key, json.get(key).toString());
                    }
                }
                //ignore json array for now, as we can't pass input parameters into it
            }
        }
        return list;
    }

    @Override
    public String GerParameterIdentity(ContentParameterCollectionInfo parameters) {
        if(parameters.containsKey(ContentController.LF_CONTENT_TYPE) && parameters.containsKey(ContentController.LF_PLAY_LOAD))
        {
            return parameters.get(ContentController.LF_PLAY_LOAD).toString();
        }
        return "$JsonParameter$";
    }
}
