package LinkFuture.Core.ContentManager.ContentParameter;

import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ParameterInfo;
import LinkFuture.Core.MemoryManager.MemoryFactory;
import LinkFuture.Core.MemoryManager.Meta.MemoryInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryMetaInfo;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */
public abstract class ContentBaseParameter implements IContentParameter
{
    public ParameterInfo CurrentParameter;

    public ContentBaseParameter(ParameterInfo currentParameter)
    {
        this.CurrentParameter = currentParameter;
    }

    public abstract CaseInsensitiveMap<Object> GerResource(ContentParameterCollectionInfo parameters) throws Exception;
    public abstract String GerParameterIdentity(ContentParameterCollectionInfo parameters);

    public CaseInsensitiveMap<Object> GerParameter(ContentParameterCollectionInfo parameters) throws Exception {
        MemoryMetaInfo meta = MemoryFactory.findCacheMetaInfo(this.CurrentParameter.CacheSettingKey);
        Object[] passArgs= new Object[] {parameters};
        if(meta==null)
        {
            return Callback(passArgs);
        }
        else
        {
            meta.Key  =this.GerParameterIdentity(parameters);
            meta.Action = new Operation<Object>(passArgs) {
                @Override
                public Object call() throws Exception {
                    return Callback(this.params);
                }
            };
            MemoryInfo<CaseInsensitiveMap<Object>> myMemory = MemoryFactory.set(meta);
            return (myMemory==null)?null:myMemory.cachedObject;
        }
    }
    public CaseInsensitiveMap<Object> Callback(Object... args) throws Exception {
        ContentParameterCollectionInfo parameters = (ContentParameterCollectionInfo)args[0];
        Debugger.LogFactory.trace("Retrieve Parameter: {}", this.CurrentParameter.Name);
        return GerResource(parameters);
    }
}
