/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Init;

import LinkFuture.Init.Config;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.PathExtension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.ConvertUtilsBean;

public class Utility {
    private static Map<String, Field> neverExpiredFieldObject = new ConcurrentHashMap<String, Field>();
    static final ConvertUtilsBean convertUtils = new ConvertUtilsBean();

    public static <T extends Annotation> Field findField(Class<?> type, Class<T> annotationClass) throws Exception {
        String classKey = "$Utility$findField".concat(type.getName()).concat(annotationClass.getName());
        if (!neverExpiredFieldObject.containsKey(classKey)) {
            neverExpiredFieldObject.put(classKey, Utility.findFieldEx(type, annotationClass));
        }
        return neverExpiredFieldObject.get(classKey);
    }

    private static <T extends Annotation> Field findFieldEx(Class<?> type, Class<T> annotationClass) {
        for (Field field : type.getDeclaredFields()) {
            if (field.getAnnotation(annotationClass) == null) continue;
            return field;
        }
        throw new IllegalArgumentException("Specific ".concat(type.getName()).concat(" must have annotation ").concat(annotationClass.getName()));
    }

    public static <T> T cast(Object value, Class<T> fieldType) {
        if (fieldType == UUID.class) {
            return (T)UUID.fromString((String)value);
        }
        if (fieldType == Boolean.class && value instanceof String) {
            return (T)Boolean.valueOf(((String)value).equalsIgnoreCase("YES") || ((String)value).equalsIgnoreCase("TRUE") || ((String)value).equalsIgnoreCase("1"));
        }
        return (T)convertUtils.convert(value, fieldType);
    }

    public static String getStringFromFile(String filePath) throws IOException {
        return Utility.getStringFromFile(filePath, "UTF-8");
    }

    public static String getStringFromFile(String filePath, String encoding) throws IOException {
        return Utility.read(new InputStreamReader(Utility.getStreamFromFile(filePath), encoding));
    }

    public static InputStream getStreamFromFile(String filePath) throws FileNotFoundException {
        if (filePath.startsWith("classpath:")) {
            Debugger.LogFactory.trace("Reading file: {}", (Object)filePath);
            filePath = filePath.substring("classpath:".length());
            return Utility.getResource(filePath);
        }
        String diskFilePath = PathExtension.FullPhysicalPath(filePath);
        Debugger.LogFactory.trace("Reading file: {}", (Object)diskFilePath);
        return new FileInputStream(diskFilePath);
    }

    public static InputStream getResource(String resource) {
        URL url;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            Debugger.LogFactory.debug("Trying to find [{}] using Thread.currentThread().getContextClassLoader.", (Object)resource);
            url = classLoader.getResource(resource);
            if (url != null) {
                return classLoader.getResourceAsStream(resource);
            }
        }
        if ((classLoader = Utility.class.getClassLoader()) != null) {
            Debugger.LogFactory.debug("Trying to find [{}] using Utility.class.getClassLoader.", (Object)resource);
            url = classLoader.getResource(resource);
            if (url != null) {
                return classLoader.getResourceAsStream(resource);
            }
        }
        if ((url = ClassLoader.getSystemResource(resource)) != null) {
            Debugger.LogFactory.debug("Trying to find [{}] using ClassLoader.getSystemResource().", (Object)resource);
            return ClassLoader.getSystemResourceAsStream(resource);
        }
        throw new IllegalArgumentException("Can't find file " + resource + " from class path");
    }

    public static boolean saveStringToFile(String filePath, String content, boolean isOverwrite) {
        Debugger.LogFactory.trace("Save {}", (Object)filePath);
        File file = new File(filePath);
        if (file.exists()) {
            if (isOverwrite) {
                file.delete();
            } else {
                return false;
            }
        }
        boolean saved = false;
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            bufferedWriter.write(content);
            saved = true;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return saved;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getBytesFromFile(String filePath) throws FileNotFoundException {
        Debugger.LogFactory.trace("Reading file: {}", (Object)filePath);
        File file = new File(filePath);
        if (!file.exists()) throw new FileNotFoundException("Specific file not exist, " + filePath);
        try (RandomAccessFile bufferedReader = new RandomAccessFile(filePath, "r");){
            long buffLength = bufferedReader.length();
            int length = (int)buffLength;
            if ((long)length != buffLength) {
                throw new IOException("File size >= 2 GB");
            }
            byte[] data = new byte[length];
            bufferedReader.readFully(data);
            bufferedReader.close();
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new FileNotFoundException("Specific file not exist, " + filePath);
    }

    public static String read(InputStreamReader inputStreamReader) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(inputStreamReader);){
            String inputLine;
            while ((inputLine = reader.readLine()) != null) {
                sb.append(inputLine);
                sb.append(Config.NewLine);
            }
            reader.close();
        }
        return sb.toString();
    }

    public static String read(InputStream inputStream, String encoding) throws IOException {
        return Utility.read(new InputStreamReader(inputStream, encoding));
    }
}

