/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Init.Extensions;

import LinkFuture.Init.Config;
import LinkFuture.Init.Extensions.StringExtension;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateExtension {
    public static Date Parse(String dateString) throws ParseException {
        if (StringExtension.IsNumeric(dateString)) {
            return new Date(Long.parseLong(dateString));
        }
        if (dateString.length() == 28) {
            return DateExtension.Parse(dateString, "yyyy-MM-dd HH:mm:ss.SSSZZZ");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss.SSS'Z'");
        formatter.setTimeZone(Config.UTCTimeZone);
        return formatter.parse(dateString);
    }

    public static Date Parse(String dateString, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.parse(dateString);
    }

    public static Date UTCParse(String dateString, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(Config.UTCTimeZone);
        return formatter.parse(dateString);
    }

    public static String Format(Date date) {
        return DateExtension.Format(date, "yyyy-MM-dd HH:mm:ss.SSSZZZ");
    }

    public static String Format(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static String UTFFormat(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(Config.UTCTimeZone);
        return formatter.format(date);
    }

    public static String UTFFormat(Date date) {
        return DateExtension.UTFFormat(date, "yyyy-MM-dd HH:mm:ss.SSSZZZ");
    }

    public static String ISO8601UTCFormat(Date date) {
        return DateExtension.UTFFormat(date, "yyyy/MM/dd'T'HH:mm:ss.SSS'Z'");
    }

    public static Date Convert(Timestamp timestamp) {
        long milliseconds = timestamp.getTime();
        return new Date(milliseconds);
    }
}

