/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Init.ConfigurationManager;

import LinkFuture.Init.Config;
import LinkFuture.Init.ConfigurationManager.AppSettingInfo;
import LinkFuture.Init.ConfigurationManager.ConfigurationInfo;
import LinkFuture.Init.ConfigurationManager.ProxyInfo;
import LinkFuture.Init.ConfigurationManager.ProxySettingsInfo;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Utility;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class ConfigurationController {
    public static ConfigurationInfo ConfigurationMeta = ConfigurationController.Read();

    public static String AppSettings(String key) {
        if (ConfigurationMeta != null && ConfigurationController.ConfigurationMeta.AppSettings != null && ConfigurationController.ConfigurationMeta.AppSettings.containsKey(key)) {
            return ConfigurationController.ConfigurationMeta.AppSettings.get((Object)key).Value;
        }
        return "";
    }

    private static synchronized ConfigurationInfo Read() {
        try {
            Debugger.LogFactory.trace("Init LinkFuture config file:{}", (Object)Config.getConfigFilePath());
            String configFileContent = Utility.getStringFromFile(Config.getConfigFilePath());
            if (configFileContent.trim().startsWith("<")) {
                ConfigurationInfo config = ConfigurationController.fromXml(configFileContent, ConfigurationInfo.class);
                if (config.ProxySettings != null) {
                    config.ProxySettings.SetupProxy();
                }
                return config;
            }
            return ConfigurationController.fromProperties(configFileContent);
        }
        catch (Exception ex) {
            Debugger.LogFactory.error("Init application configuration failed", (Throwable)ex);
            throw new RuntimeException("Init application configuration failed", ex);
        }
    }

    private static ConfigurationInfo fromProperties(String configFileContent) throws IOException {
        Properties file = new Properties();
        file.load(new StringReader(configFileContent));
        ConfigurationInfo config = new ConfigurationInfo();
        config.AppSettings = new HashMap();
        for (Map.Entry<Object, Object> item : file.entrySet()) {
            AppSettingInfo setting = new AppSettingInfo();
            setting.Key = item.getKey().toString();
            setting.Value = item.getValue().toString();
            if (setting.Key.startsWith("ProxySettings.")) {
                if (config.ProxySettings != null) {
                    config.ProxySettings = new ProxySettingsInfo();
                }
                if (setting.Key.startsWith("ProxySettings.HttpProxy") && config.ProxySettings.HttpProxy != null) {
                    config.ProxySettings.HttpProxy = new ProxyInfo();
                }
                if (setting.Key.startsWith("ProxySettings.HttpsProxy") && config.ProxySettings.HttpsProxy != null) {
                    config.ProxySettings.HttpsProxy = new ProxyInfo();
                }
                if (setting.Key.equalsIgnoreCase("ProxySettings.HttpProxy.Host")) {
                    config.ProxySettings.HttpProxy.Host = setting.Value;
                    continue;
                }
                if (setting.Key.equalsIgnoreCase("ProxySettings.HttpProxy.Port")) {
                    config.ProxySettings.HttpProxy.Port = setting.Value;
                    continue;
                }
                if (setting.Key.equalsIgnoreCase("ProxySettings.HttpProxy.UserName")) {
                    config.ProxySettings.HttpProxy.UserName = setting.Value;
                    continue;
                }
                if (setting.Key.equalsIgnoreCase("ProxySettings.HttpProxy.Password")) {
                    config.ProxySettings.HttpProxy.Password = setting.Value;
                    continue;
                }
                if (setting.Key.equalsIgnoreCase("ProxySettings.HttpsProxy.Host")) {
                    config.ProxySettings.HttpsProxy.Host = setting.Value;
                    continue;
                }
                if (setting.Key.equalsIgnoreCase("ProxySettings.HttpsProxy.Port")) {
                    config.ProxySettings.HttpsProxy.Port = setting.Value;
                    continue;
                }
                if (setting.Key.equalsIgnoreCase("ProxySettings.HttpsProxy.UserName")) {
                    config.ProxySettings.HttpsProxy.UserName = setting.Value;
                    continue;
                }
                if (!setting.Key.equalsIgnoreCase("ProxySettings.HttpsProxy.Password")) continue;
                config.ProxySettings.HttpsProxy.Password = setting.Value;
                continue;
            }
            config.AppSettings.put(setting.Key, setting);
        }
        return config;
    }

    private static <T> T fromXml(String xmlString, Class<T> targetClass) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{targetClass});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (T)unmarshaller.unmarshal((Reader)new StringReader(xmlString));
        }
        catch (JAXBException e) {
            Debugger.LogFactory.error("Init application configuration failed", (Throwable)e);
            Object context = null;
            return null;
        }
    }
}

