/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.MongoDBHelper;

import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MongoDBHelper {
    private MongoClient _client;
    private static final Map<String, MongoClient> connectionPool = new ConcurrentHashMap<String, MongoClient>();

    public static MongoClient getMongoClient(String mongoClientURI) throws UnknownHostException {
        if (!connectionPool.containsKey(mongoClientURI)) {
            MongoClient localClient = MongoDBHelper.connect(mongoClientURI);
            connectionPool.put(mongoClientURI, localClient);
        } else {
            Debugger.LogFactory.info("Use connection from pool {}", (Object)mongoClientURI);
            try {
                MongoClient localClient = connectionPool.get(mongoClientURI);
                localClient.getConnectPoint();
            }
            catch (IllegalStateException e) {
                Debugger.LogFactory.info("Lost connection from pool {}, reconnect", (Object)mongoClientURI);
                MongoClient localClient = MongoDBHelper.connect(mongoClientURI);
                connectionPool.put(mongoClientURI, localClient);
            }
        }
        return connectionPool.get(mongoClientURI);
    }

    private static MongoClient connect(String mongoClientURI) throws UnknownHostException {
        Debugger.LogFactory.info("Connecting to mongo DB {}", (Object)mongoClientURI);
        MongoClientURI connectionUri = new MongoClientURI(mongoClientURI);
        MongoClient localClient = new MongoClient(connectionUri);
        String defaultDBName = connectionUri.getDatabase();
        Debugger.LogFactory.info("Connected to mongo DB, current version is {}", (Object)localClient.getVersion());
        if (!StringExtension.IsNullOrEmpty(defaultDBName)) {
            localClient.getDB(defaultDBName);
            Debugger.LogFactory.info("Use {} database", (Object)defaultDBName);
        }
        return localClient;
    }

    public MongoDBHelper(String mongoClientURI) throws UnknownHostException {
        this(MongoDBHelper.getMongoClient(mongoClientURI));
    }

    public MongoDBHelper(MongoClient client) {
        this.setClient(client);
    }

    public Collection<DB> getUsedDatabases() {
        return this.getClient().getUsedDatabases();
    }

    public MongoClient getClient() {
        return this._client;
    }

    public void setClient(MongoClient client) {
        this._client = client;
    }

    public DB getDefaultDB() {
        Collection<DB> list = this.getUsedDatabases();
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("We don't have default DB, please specific one");
        }
        Iterator<DB> itr = list.iterator();
        DB last = itr.next();
        while (itr.hasNext()) {
            last = itr.next();
        }
        return last;
    }

    public String execute(String commandText, Object ... args) {
        return this.execute(this.getDefaultDB(), commandText, args);
    }

    public String execute(DB selectedDB, String commandText, Object ... args) {
        CommandResult result = selectedDB.command(BasicDBObjectBuilder.start().add("$eval", (Object)commandText).add("args", (Object)args).add("nolock", (Object)true).get());
        if (result.ok()) {
            return result.toString();
        }
        return null;
    }

    public String execute(DB selectedDB, String commandText, HashMap<String, Object> args) {
        List<String> paramList = MongoDBHelper.readFunctionParameters(commandText);
        Object[] passedParam = new Object[paramList.size()];
        for (int i = 0; i < passedParam.length; ++i) {
            passedParam[i] = args.get(paramList.get(i));
        }
        return this.execute(selectedDB, commandText, passedParam);
    }

    public String execute(String commandText, HashMap<String, Object> args) {
        return this.execute(this.getDefaultDB(), commandText, args);
    }

    public static List<String> readFunctionParameters(String functionCode) {
        Pattern pattern;
        Matcher matcher;
        ArrayList<String> list = new ArrayList<String>();
        if ((functionCode = functionCode.trim()).startsWith("function(") && (matcher = (pattern = Pattern.compile("function\\(([^)]*)\\)", 2)).matcher(functionCode)).find()) {
            String param = matcher.group(1);
            for (String item : param.split(",")) {
                list.add(item.trim());
            }
        }
        return list;
    }

    public void close() {
        if (this._client != null) {
            Debugger.LogFactory.info("close Mongo DB connection: {}", (Object)this._client.getAddress().toString());
            this._client.close();
        }
    }

    public static void closeAll() {
        for (MongoClient client : connectionPool.values()) {
            Debugger.LogFactory.info("close Mongo DB connection: {}", (Object)client.getAddress().toString());
            client.close();
        }
    }
}

