/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.MemoryManager.Redis;

import LinkFuture.Core.MemoryManager.IMemoryController;
import LinkFuture.Core.MemoryManager.Meta.MemoryInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryMetaInfo;
import LinkFuture.Core.MemoryManager.Redis.RedisHelper;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Init.Debugger;
import java.net.URI;

public class RedisMemoryController
implements IMemoryController,
AutoCloseable {
    private RedisHelper redisHelper;

    public RedisMemoryController(String redisServers) {
        try {
            this.redisHelper = new RedisHelper(new URI(redisServers));
        }
        catch (Exception e) {
            Debugger.fatal("RedisHelper init error", e);
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public <T> MemoryInfo<T> addNeverExpiredMemoryCache(String key, Operation operation) throws Exception {
        MemoryMetaInfo meta = new MemoryMetaInfo();
        meta.Key = key;
        meta.Action = operation;
        return this.addMemoryCache(meta);
    }

    @Override
    public <T> MemoryInfo<T> addNeverExpiredMemoryCache(String key, Object value) throws Exception {
        return this.addMemoryCache(key, value, null);
    }

    @Override
    public <T> MemoryInfo<T> addMemoryCache(MemoryMetaInfo meta) throws Exception {
        if (!meta.Enable) {
            Debugger.LogFactory.trace("this cache setting({}) has been disabled, call it directly ", (Object)meta.Key);
            MemoryInfo output = new MemoryInfo();
            output.meta = meta;
            output.cachedObject = meta.Action.call();
            return output;
        }
        MemoryInfo<Object> cachedResults = this.redisHelper.get(meta.getUniqueKey());
        if (cachedResults != null) {
            Debugger.LogFactory.trace("load memory from redis ({}) for key {}", (Object)meta.CacheType, (Object)meta.Key);
            return cachedResults;
        }
        Object result = meta.Action.call();
        cachedResults = meta.Duration == 0 ? this.redisHelper.set(meta.getUniqueKey(), result, meta.Duration) : this.redisHelper.set(meta.getUniqueKey(), result, meta.Duration * 60);
        Debugger.LogFactory.trace("add memory into redis({}) for key {}", (Object)meta.CacheType, (Object)meta.Key);
        return cachedResults;
    }

    @Override
    public <T> MemoryInfo<T> addMemoryCache(String key, final Object value, Integer duration) throws Exception {
        MemoryMetaInfo meta = new MemoryMetaInfo();
        meta.Action = new Operation(new Object[0]){

            @Override
            public Object call() throws Exception {
                return value;
            }
        };
        meta.Duration = duration;
        return this.addMemoryCache(meta);
    }

    @Override
    public <T> MemoryInfo<T> getMemory(String key) {
        MemoryMetaInfo meta = new MemoryMetaInfo();
        meta.Key = key;
        Debugger.LogFactory.trace("load memory from redis({}) for key {}", (Object)meta.CacheType, (Object)meta.Key);
        return this.redisHelper.get(meta.getUniqueKey());
    }

    @Override
    public void clear(String key) {
        this.redisHelper.del(key);
    }

    @Override
    public void close() {
        this.redisHelper.disconnect();
    }
}

