/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.MemoryManager.Redis;

import LinkFuture.Core.MemoryManager.Meta.MemoryInfo;
import LinkFuture.Core.MemoryManager.Redis.RedisMemoryInfo;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.ObjectExtend.TimeSpan;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisHelper {
    private static JedisPool jedisPool;
    private Jedis jedis;

    public synchronized Jedis getJedisConnection(URI redisServersUrl, int timeout) {
        if (jedisPool == null) {
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(1000);
            config.setMaxIdle(10);
            config.setMinIdle(1);
            config.setMaxWaitMillis(30000L);
            config.setTestOnBorrow(true);
            jedisPool = new JedisPool((GenericObjectPoolConfig)config, redisServersUrl, timeout);
            Debugger.LogFactory.trace("Init redis pool");
        }
        return jedisPool.getResource();
    }

    public RedisHelper(URI redisServersUrl, int timeout) throws Exception {
        this.jedis = this.getJedisConnection(redisServersUrl, timeout);
    }

    public RedisHelper(URI redisServersUrl) throws Exception {
        this(redisServersUrl, 10000);
    }

    public void selectDB(int dbNumber) {
        this.jedis.select(dbNumber);
    }

    public void disconnect() {
        this.jedis.close();
    }

    public void destory() {
        this.jedis.close();
        jedisPool.destroy();
    }

    public void set(String key, Object value) {
        this.set(key, value, null);
    }

    public <T> MemoryInfo<T> set(String key, T value, Integer second) {
        try {
            RedisMemoryInfo memoryInfo = new RedisMemoryInfo();
            memoryInfo.classType = value.getClass();
            memoryInfo.cachedTime = System.currentTimeMillis();
            if (second != null) {
                memoryInfo.expiredTime = memoryInfo.cachedTime + TimeSpan.FromSec(second.intValue()).getTimeStamp();
            }
            memoryInfo.cachedObject = value instanceof String ? value : Utility.jacksonToJson(value);
            String passValue = Utility.jacksonToJson(memoryInfo);
            if (second == null) {
                this.jedis.set(key, passValue);
            } else {
                this.jedis.setex(key, second.intValue(), passValue);
            }
            return memoryInfo.getMemoryInfo(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public <T> MemoryInfo<T> get(String key) {
        String output = this.jedis.get(key);
        if (output == null) {
            return null;
        }
        if (output.contains("\"classType\":\"")) {
            try {
                RedisMemoryInfo myValue = Utility.jacksonFromJson(output, RedisMemoryInfo.class, new Class[0]);
                if (myValue.classType == String.class) {
                    return myValue.getMemoryInfo(myValue.cachedObject);
                }
                return myValue.getMemoryInfo(Utility.jacksonFromJson(myValue.cachedObject.toString(), myValue.classType, new Class[0]));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        throw new RuntimeException("Unexpected redis value format,");
    }

    public void del(String key) {
        this.jedis.del(key);
    }
}

