/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.MemoryManager;

import LinkFuture.Core.MemoryManager.IMemoryController;
import LinkFuture.Core.MemoryManager.Meta.MemoryInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryMetaInfo;
import LinkFuture.Core.MemoryManager.Meta.MemorySettingInfo;
import LinkFuture.Core.MemoryManager.Meta.MemorySettingListInfo;
import LinkFuture.Core.MemoryManager.Meta.MemorySource;
import LinkFuture.Core.MemoryManager.Redis.RedisMemoryController;
import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryController;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Core.Utility;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Init.Debugger;

public class MemoryFactory {
    public static final MemorySettingListInfo ConfigurationMeta = MemoryFactory.read();

    private static MemorySettingListInfo read() {
        try {
            return Utility.fromXml(LinkFuture.Init.Utility.getStringFromFile(ConfigurationController.AppSettings("MemoryCatchFilePath")), MemorySettingListInfo.class);
        }
        catch (Exception ex) {
            Debugger.LogFactory.error("Init memory setting failed", (Throwable)ex);
            throw new RuntimeException("Init memory setting failed, due to", ex);
        }
    }

    public static <T> MemoryInfo<T> set(String key, final String value, String cacheSettingName) throws Exception {
        return MemoryFactory.set(key, new Operation(new Object[0]){

            @Override
            public Object call() throws Exception {
                return value;
            }
        }, cacheSettingName);
    }

    public static <T> MemoryInfo<T> set(String key, Operation operation, String cacheSettingName) throws Exception {
        MemoryMetaInfo setting = MemoryFactory.findCacheMetaInfo(cacheSettingName);
        if (setting == null) {
            throw new IllegalArgumentException("specific cache setting does not exist.");
        }
        setting.Key = key;
        setting.Action = operation;
        return MemoryFactory.set(setting);
    }

    public static <T> MemoryInfo<T> set(MemoryMetaInfo setting) throws Exception {
        IMemoryController controller = MemoryFactory.findMemoryCacheAdapter(setting.CacheSource);
        MemoryInfo output = controller.addMemoryCache(setting);
        controller.close();
        return output;
    }

    public static MemoryMetaInfo findCacheMetaInfo(String cacheSettingName) {
        if (ConfigurationMeta == null || !MemoryFactory.ConfigurationMeta.SettingList.containsKey(cacheSettingName)) {
            return null;
        }
        MemorySettingInfo setting = MemoryFactory.ConfigurationMeta.SettingList.get(cacheSettingName);
        if (setting == null) {
            return null;
        }
        return MemoryMetaInfo.build(setting);
    }

    public static <T> MemoryInfo<T> get(String key, String cacheSettingName) {
        MemoryMetaInfo setting = MemoryFactory.findCacheMetaInfo(cacheSettingName);
        if (setting == null) {
            throw new IllegalArgumentException("specific cache setting does not exist.");
        }
        if (!setting.Enable) {
            throw new IllegalArgumentException("cache setting has been disabled, you can't get value");
        }
        IMemoryController controller = MemoryFactory.findMemoryCacheAdapter(setting.CacheSource);
        MemoryInfo output = controller.getMemory(key);
        controller.close();
        return output;
    }

    private static IMemoryController findMemoryCacheAdapter(MemorySource source) {
        switch (source) {
            case Redis: {
                return new RedisMemoryController(MemoryFactory.ConfigurationMeta.RedisUrl);
            }
        }
        return new StaticMemoryController();
    }
}

