/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.GenericRepository.Repository;

import LinkFuture.Core.ContentManager.Model.ContentType;
import LinkFuture.Core.ContentManager.Model.ResponseType;
import LinkFuture.Core.GenericRepository.Entity.GenericResponse;
import LinkFuture.Core.GenericRepository.Repository.BaseRepository;
import LinkFuture.Core.GenericRepository.Repository.IGenericRepository;
import LinkFuture.Core.JsonManager.JsonController;
import LinkFuture.Core.UriBuilder;
import LinkFuture.Core.Utility;
import LinkFuture.Core.WebClient.HttpMethod;
import LinkFuture.Core.WebClient.WebClient;
import LinkFuture.Core.WebClient.WebClientResultInfo;
import LinkFuture.Core.WebClient.WebRequestInfo;
import LinkFuture.Init.Extensions.StringExtension;
import java.io.Serializable;
import java.net.URL;
import org.json.JSONObject;

public abstract class GenericWebRepository<T, ID extends Serializable>
extends BaseRepository<T, ID>
implements IGenericRepository<T, ID> {
    private int retryTimes = 3;

    public GenericWebRepository(String requestPath) {
        super(requestPath);
    }

    public void setRetryTimes(int times) {
        this.retryTimes = times;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    @Override
    protected <R> Object genericDBResourceLoad(String requestUrl, HttpMethod method, R requestObject, String cacheSetting) throws Exception {
        WebRequestInfo meta = new WebRequestInfo();
        meta.addHead("Accept", (Object)ResponseType.Json);
        meta.RequestMethod = method;
        switch (method) {
            case Get: {
                UriBuilder uriBuilder = UriBuilder.create(requestUrl).addQuery("$JsonQuery", Utility.jacksonToJson(requestObject));
                if (!StringExtension.IsNullOrEmpty(cacheSetting)) {
                    uriBuilder.addQuery("$Cache", cacheSetting);
                }
                meta.RequestURL = uriBuilder.buildURL();
                break;
            }
            case Delete: {
                UriBuilder uriBuilder = UriBuilder.create(requestUrl).addQuery("$JsonQuery", Utility.jacksonToJson(requestObject));
                meta.RequestURL = uriBuilder.buildURL();
                break;
            }
            case Post: 
            case Put: {
                meta.RequestURL = new URL(requestUrl);
                meta.addHead("Content-Type", ContentType.Json.getContentType());
                meta.addPayload(Utility.jacksonToJson(requestObject));
            }
        }
        WebClientResultInfo result = WebClient.sendRequest(meta, this.getRetryTimes());
        if (result.success) {
            logger.trace(result.response == null ? "No result found" : result.response);
            return new JSONObject(result.response).get("response");
        }
        if (result.response != null && JsonController.isJsonObject(result.response)) {
            throw new IllegalArgumentException(Utility.jacksonFromJson((String)result.response, GenericResponse.class, new Class[]{String.class}).meta.message);
        }
        throw new IllegalArgumentException(result.errorMessage);
    }
}

