/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.GenericRepository.Entity.Operation;

import LinkFuture.Core.GenericRepository.Entity.Operation.OperationBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OperationBuilder<T extends OperationBuilder<T>> {
    Class<?> operationType;
    private List<Object> queryMaps = new ArrayList<Object>();

    public OperationBuilder(Class<? extends OperationBase> type) {
        this.operationType = type;
    }

    public T add(Number ... numbers) {
        this.queryMaps.addAll(Arrays.asList(numbers));
        return (T)this;
    }

    public T add(String ... fields) {
        this.queryMaps.addAll(Arrays.asList(fields));
        return (T)this;
    }

    public T add(OperationBase ... operationBases) {
        this.queryMaps.addAll(Arrays.asList(operationBases));
        return (T)this;
    }

    public OperationBase build() throws IllegalAccessException, InstantiationException {
        OperationBase output = (OperationBase)this.operationType.newInstance();
        if (this.queryMaps.size() < 2) {
            throw new IllegalArgumentException("You must have two number for " + output.getOperation());
        }
        output.put(output.getOperation(), this.queryMaps);
        return output;
    }
}

