/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.GenericWhereQueryInfo;
import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.CommandTypeInfo;
import LinkFuture.Core.DBHelper.Model.DBTypeInfo;
import LinkFuture.Init.Config;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.naming.NamingException;
import org.json.JSONArray;
import org.json.JSONObject;

public class GenericDBHelper
extends DBHelper {
    public static final String $WHERE = "$where";
    public static final String $OR = "$or";
    public static final String $SORT = "$sort";
    public static final String $LIMIT = "$limit";
    public static final String $OFFSET = "$offset";
    public static final String $UPSERT = "$upsert";
    public static final String $LIKE = "$like";
    public static final String $SIMILAR = "$similar";
    public static final String $CONTAIN = "$contain";
    public static final String $ANY = "$any";
    public static final String $BETWEEN = "$between";
    public static final String $IN = "$in";
    public static final String $GT = "$gt";
    public static final String $GTE = "$gte";
    public static final String $LT = "$lt";
    public static final String $LTE = "$lte";
    public static final String $NE = "$ne";
    public static final List<String> $WHERE_FUNCTIONS = Arrays.asList("$like", "$similar", "$contain", "$any", "$between", "$gt", "$gte", "$lt", "$lte", "$ne");
    public static final String $SUM = "$sum";
    public static final String $COUNT = "$count";
    public static final String $MIN = "$min";
    public static final String $MAX = "$max";
    public static final String $AVG = "$avg";
    public static final String $GROUP = "$group";
    public static final List<String> $AGGREGATE_FUNCTIONS = Arrays.asList("$sum", "$count", "$min", "$max", "$avg");
    public static final String $MULTIPLY = "$multiply";
    public static final String $DIVIDE = "$divide";
    public static final String $PLUS = "$plus";
    public static final String $MINUS = "$minus";
    public static final String $MODULE = "$module";
    public static final List<String> $ARITHMETIC_FUNCTIONS = Arrays.asList("$multiply", "$divide", "$plus", "$minus", "$module");

    public GenericDBHelper(String connectionString) throws IOException, SQLException, ClassNotFoundException, NamingException {
        super(connectionString);
    }

    private String buildColumnValue(ColumnInfo column, String uniqueColumnName) {
        if (uniqueColumnName == null) {
            uniqueColumnName = column.columnName;
        }
        if (column.sqlType == 2002 || column.sqlType == -7) {
            return String.format("$%s|%s::%s", uniqueColumnName, column.sqlType, column.sqlTypeName);
        }
        if (column.sqlType == 2003) {
            return String.format("$%s|%s::%s[]", uniqueColumnName, column.sqlType, column.getArrayElementTypeName());
        }
        return String.format("$%s|%s", uniqueColumnName, column.sqlType);
    }

    private String buildWhereValue(GenericWhereQueryInfo queryInfo) throws IllegalAccessException {
        if (queryInfo.getValueColumn().sqlType == 2003) {
            return String.format("$%s|%s::%s[] = %s", queryInfo.getUniqueName(), queryInfo.getValueColumn().sqlType, queryInfo.getValueColumn().getArrayElementTypeName(), queryInfo.getColumnName());
        }
        if (queryInfo.getValueColumn().isPasswordType() || queryInfo.getValueColumn().isSerialType()) {
            return String.format("%s = $%s|%s", queryInfo.getColumnName(), queryInfo.getUniqueName(), queryInfo.getValueColumn().sqlType);
        }
        if (queryInfo.getValueColumn().sqlType == -7 || queryInfo.getValueColumn().isSqlJsonType() || StringExtension.IsNullOrEmpty(queryInfo.getSubQuery())) {
            return String.format("%s = $%s|%s::%s", queryInfo.getColumnName(), queryInfo.getUniqueName(), queryInfo.getValueColumn().sqlType, queryInfo.getValueColumn().sqlTypeName);
        }
        return String.format("%s = $%s|%s", queryInfo.getColumnName(), queryInfo.getUniqueName(), queryInfo.getValueColumn().sqlType);
    }

    private Object getUpsertValue(Object updatedValue) {
        if (updatedValue instanceof JSONObject && ((JSONObject)updatedValue).has($UPSERT)) {
            return ((JSONObject)updatedValue).get($UPSERT);
        }
        return null;
    }

    private String buildUpdateValue(ColumnInfo column, String subQuery, String uniqueColumnName, boolean jsonUpsertModel) {
        if (column.sqlType == -7) {
            return String.format("%s = $%s|%s::%s", column.columnName, uniqueColumnName, column.sqlType, column.sqlTypeName);
        }
        if (column.isSqlJsonType() && jsonUpsertModel) {
            return String.format("%s = jsonb_merge(%s::JSONB, $%s|%s::JSONB)::%s", column.columnName, column.columnName, uniqueColumnName, column.sqlType, column.sqlTypeName);
        }
        if (StringExtension.IsNullOrEmpty(subQuery)) {
            return String.format("%s=%s", column.columnName, this.buildColumnValue(column, uniqueColumnName));
        }
        if (column.sqlType == 2002) {
            return String.format("%s.%s = $%s|%s", column.columnName, subQuery, uniqueColumnName, column.getStructElementColumn((String)subQuery).sqlType);
        }
        return String.format("%s.%s= $%s|%s", column.columnName, subQuery, uniqueColumnName, 12);
    }

    public Object insert(String tableName, JSONObject obj) throws Exception {
        JSONArray array = new JSONArray();
        array.put((Object)obj);
        List<Object> list = this.insert(tableName, array);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public List<Object> insert(String tableName, JSONArray obj) throws Exception {
        return super.insert(this.buildInsertTSQL(tableName, obj));
    }

    public int delete(String tableName, NameValuePair ... params) throws Exception {
        JSONObject jsonQuery = this.getQueryJSON(params);
        return this.delete(tableName, jsonQuery);
    }

    public int delete(String tableName, JSONObject jsonQuery) throws Exception {
        return super.executeSQL(this.buildDeleteTSQL(tableName, jsonQuery));
    }

    public int update(String tableName, NameValuePair ... params) throws Exception {
        JSONObject jsonQuery = this.getQueryJSON(params);
        return this.update(tableName, jsonQuery);
    }

    public int update(String tableName, JSONObject jsonQuery) throws Exception {
        return super.executeSQL(this.buildUpdateTSQL(tableName, jsonQuery));
    }

    public JSONObject selectToJson(String tableName, NameValuePair ... params) throws Exception {
        JSONObject jsonQuery = this.getQueryJSON(params);
        return this.selectToJson(tableName, jsonQuery);
    }

    public JSONObject selectToJson(String tableName, JSONObject jsonQuery) throws Exception {
        return super.executeToJson(this.buildSelectTSQL(tableName, jsonQuery), CommandTypeInfo.TSQL);
    }

    public String executeToXml(String tableName, NameValuePair ... params) throws Exception {
        JSONObject jsonQuery = this.getQueryJSON(params);
        return this.selectToXml(tableName, jsonQuery);
    }

    public String selectToXml(String tableName, JSONObject jsonQuery) throws Exception {
        return super.executeToXml(this.buildSelectTSQL(tableName, jsonQuery), CommandTypeInfo.TSQL);
    }

    public String buildDeleteTSQL(String tableName, JSONObject jsonQuery) throws Exception {
        HashMap<String, ColumnInfo> columnList = super.getTableColumnList(tableName);
        String where = this.buildWhereTSQL(columnList, jsonQuery);
        if (StringExtension.IsNullOrEmpty(where)) {
            throw new IllegalArgumentException("Please specific where condition or none of condition is valid for table " + tableName);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(tableName);
        sb.append(" WHERE ");
        sb.append(where);
        return sb.toString();
    }

    public String buildWhereTSQL(HashMap<String, ColumnInfo> columnList, JSONObject jsonWhere) {
        Iterable iterable = () -> ((JSONObject)jsonWhere).keys();
        StringBuilder sb = new StringBuilder();
        String andString = StreamSupport.stream(iterable.spliterator(), false).filter(key -> {
            List<String> inputColumnName = this.getInputColumnName((String)key);
            return columnList.containsKey(inputColumnName.get(0));
        }).map(key -> {
            Object jsonValue = jsonWhere.get(key);
            List<String> columnNameList = this.getInputColumnName((String)key);
            ColumnInfo column = (ColumnInfo)columnList.get(columnNameList.get(0));
            GenericWhereQueryInfo queryInfo = new GenericWhereQueryInfo(column, columnNameList.get(1), this.getUniqueSqlParameterName(column.columnName));
            if (jsonValue instanceof JSONObject && $WHERE_FUNCTIONS.contains(((String)((JSONObject)jsonValue).keys().next()).toLowerCase())) {
                JSONObject compare = (JSONObject)jsonValue;
                String operationString = ((String)compare.keySet().iterator().next()).toLowerCase();
                Object operationValue = compare.get(operationString);
                switch (operationString) {
                    case "$gt": {
                        if (!comparableTypes.contains(queryInfo.getValueColumn().sqlType)) {
                            throw new IllegalArgumentException("Specific type does not support $gt operation");
                        }
                        super.addParameter(queryInfo.getUniqueName(), operationValue);
                        return String.format("%s > $%s|%s", queryInfo.getColumnName(), queryInfo.getUniqueName(), queryInfo.getValueColumn().sqlType);
                    }
                    case "$gte": {
                        if (!comparableTypes.contains(queryInfo.getValueColumn().sqlType)) {
                            throw new IllegalArgumentException("Specific type does not support $gte operation");
                        }
                        super.addParameter(queryInfo.getUniqueName(), operationValue);
                        return String.format("%s >= $%s|%s", queryInfo.getColumnName(), queryInfo.getUniqueName(), queryInfo.getValueColumn().sqlType);
                    }
                    case "$lt": {
                        if (!comparableTypes.contains(queryInfo.getValueColumn().sqlType)) {
                            throw new IllegalArgumentException("Specific type does not support $lt operation");
                        }
                        super.addParameter(queryInfo.getUniqueName(), operationValue);
                        return String.format("%s < $%s|%s", queryInfo.getColumnName(), queryInfo.getUniqueName(), queryInfo.getValueColumn().sqlType);
                    }
                    case "$lte": {
                        if (!comparableTypes.contains(queryInfo.getValueColumn().sqlType)) {
                            throw new IllegalArgumentException("Specific type does not support $lte operation");
                        }
                        super.addParameter(queryInfo.getUniqueName(), operationValue);
                        return String.format("%s <= $%s|%s", queryInfo.getColumnName(), queryInfo.getUniqueName(), queryInfo.getValueColumn().sqlType);
                    }
                    case "$ne": {
                        if (!comparableTypes.contains(queryInfo.getValueColumn().sqlType)) {
                            throw new IllegalArgumentException("Specific type does not support $lte operation");
                        }
                        super.addParameter(queryInfo.getUniqueName(), operationValue);
                        return String.format("%s != $%s|%s", queryInfo.getColumnName(), queryInfo.getUniqueName(), queryInfo.getValueColumn().sqlType);
                    }
                    case "$like": {
                        if (!likeableTypes.contains(queryInfo.getValueColumn().sqlType)) {
                            throw new IllegalArgumentException("Specific type does not support $like operation");
                        }
                        super.addParameter(queryInfo.getUniqueName(), operationValue);
                        return String.format("%s LIKE $%s|%s", queryInfo.getColumnName(), queryInfo.getUniqueName(), queryInfo.getValueColumn().sqlType);
                    }
                    case "$similar": {
                        if (!likeableTypes.contains(queryInfo.getValueColumn().sqlType)) {
                            throw new IllegalArgumentException("Specific type does not support $similar operation");
                        }
                        if (this.DBType != DBTypeInfo.PostgreSQL) {
                            throw new IllegalArgumentException("$similar operation only support PostgreSQL database");
                        }
                        super.addParameter(queryInfo.getUniqueName(), operationValue);
                        return String.format("%s SIMILAR TO $%s|%s", queryInfo.getColumnName(), queryInfo.getUniqueName(), queryInfo.getValueColumn().sqlType);
                    }
                    case "$in": {
                        JSONArray inList = (JSONArray)operationValue;
                        ArrayList<String> inString = new ArrayList<String>();
                        for (int i = 0; i < inList.length(); ++i) {
                            inString.add("'" + inList.get(i).toString() + "'");
                        }
                        return String.format("%s in (%s)", queryInfo.getColumnName(), StringExtension.Join(inString, ","));
                    }
                    case "$between": {
                        JSONArray betweenList = (JSONArray)operationValue;
                        if (queryInfo.getValueColumn().isNumberType()) {
                            return String.format("%s between %s and %s", queryInfo.getColumnName(), betweenList.get(0), betweenList.get(1));
                        }
                        if (queryInfo.getValueColumn().isDateType()) {
                            String from = queryInfo.getUniqueName() + "_1";
                            String to = queryInfo.getUniqueName() + "_2";
                            super.addParameter(from, betweenList.get(0));
                            super.addParameter(to, betweenList.get(1));
                            return String.format("%s between $%s|%s::%s and $%s|%s::%s", queryInfo.getColumnName(), from, queryInfo.getValueColumn().sqlType, queryInfo.getValueColumn().sqlTypeName, to, queryInfo.getValueColumn().sqlType, queryInfo.getValueColumn().sqlTypeName);
                        }
                        throw new IllegalArgumentException("Only number and date type support between operation");
                    }
                    case "$contain": {
                        if (queryInfo.getValueColumn().sqlType == 2003) {
                            super.addParameter(queryInfo.getUniqueName(), operationValue);
                            return String.format("%s @> $%s|%s::%s[]", queryInfo.getColumnName(), queryInfo.getUniqueName(), queryInfo.getValueColumn().sqlType, queryInfo.getValueColumn().getArrayElementTypeName());
                        }
                        if (queryInfo.getValueColumn().isSqlJsonType()) {
                            super.addParameter(queryInfo.getUniqueName(), operationValue);
                            return String.format("%s @> $%s|%s::%s", queryInfo.getColumnName(), queryInfo.getUniqueName(), queryInfo.getValueColumn().sqlType, queryInfo.getValueColumn().sqlTypeName);
                        }
                        throw new IllegalArgumentException("Only array type support any operation");
                    }
                    case "$any": {
                        if (queryInfo.getValueColumn().sqlType == 2003) {
                            super.addParameter(queryInfo.getUniqueName(), operationValue);
                            try {
                                return String.format("$%s|%s::%s= ANY(%s)", queryInfo.getUniqueName(), queryInfo.getValueColumn().getArrayElementType(), queryInfo.getValueColumn().getArrayElementTypeName(), queryInfo.getColumnName());
                            }
                            catch (IllegalAccessException e) {
                                throw new IllegalArgumentException(e.getMessage());
                            }
                        }
                        throw new IllegalArgumentException("Only array type support any operation");
                    }
                }
                throw new IllegalArgumentException(String.format("Specific operation %s not support yet", operationString));
            }
            try {
                super.addParameter(queryInfo.getUniqueName(), jsonValue);
                return this.buildWhereValue(queryInfo);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }).collect(Collectors.joining(" AND "));
        sb.append(andString);
        if (jsonWhere.has($OR)) {
            JSONArray orArray = jsonWhere.getJSONArray($OR);
            for (int i = 0; i < orArray.length(); ++i) {
                if (i != 0 || andString.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append("(");
                sb.append(this.buildWhereTSQL(columnList, orArray.getJSONObject(i)));
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public String buildSortTSQL(HashMap<String, ColumnInfo> columnList, JSONObject jsonSort) {
        Iterable iterable = () -> jsonSort.keys();
        String sortQuery = StreamSupport.stream(iterable.spliterator(), false).filter(key -> columnList.containsKey(key)).map(key -> {
            String jsonValue = jsonSort.getString(key);
            if (jsonValue.equalsIgnoreCase("DESC")) {
                return String.format("%s DESC", key);
            }
            return String.format("%s ASC", key);
        }).collect(Collectors.joining(","));
        return StringExtension.IsNullOrEmpty(sortQuery) ? null : " ORDER BY ".concat(sortQuery);
    }

    public String buildInsertTSQL(String tableName, JSONArray obj) throws Exception {
        HashMap<String, ColumnInfo> columnList = super.getTableColumnList(tableName);
        Supplier<Stream> columnStream = () -> columnList.values().stream();
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(tableName);
        for (int i = 0; i < obj.length(); ++i) {
            JSONObject item = obj.getJSONObject(i);
            if (i == 0) {
                sb.append("(");
                sb.append(columnStream.get().filter(c -> item.has(c.columnName)).map(c -> c.columnName).collect(Collectors.joining(",")));
                sb.append(") VALUES");
            }
            sb.append("(");
            sb.append(columnStream.get().filter(c -> item.has(c.columnName)).map(c -> {
                String uniqueName = this.getUniqueSqlParameterName(c.columnName);
                super.addParameter(uniqueName, this.getPassedValue(item, c.columnName));
                return this.buildColumnValue((ColumnInfo)c, uniqueName);
            }).collect(Collectors.joining(",")));
            sb.append(")");
            if (i == obj.length() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public Object getPassedValue(JSONObject item, String key) {
        Object insertValue = item.get(key);
        if (insertValue == JSONObject.NULL) {
            return null;
        }
        return insertValue;
    }

    public String buildUpdateTSQL(String tableName, JSONObject jsonQuery) throws Exception {
        HashMap<String, ColumnInfo> columnList = super.getTableColumnList(tableName);
        if (!jsonQuery.has($WHERE)) {
            throw new IllegalArgumentException("Please specific where condition or none of condition is valid for table " + tableName);
        }
        String where = this.buildWhereTSQL(columnList, jsonQuery.getJSONObject($WHERE));
        if (StringExtension.IsNullOrEmpty(where)) {
            throw new IllegalArgumentException("Please specific where condition or none of condition is valid for table " + tableName);
        }
        Iterable iterable = () -> jsonQuery.keys();
        String setString = StreamSupport.stream(iterable.spliterator(), false).filter(key -> {
            List<String> inputColumnName = this.getInputColumnName((String)key);
            return columnList.containsKey(inputColumnName.get(0));
        }).map(key -> {
            Object upsertValue;
            List<String> columnNameList = this.getInputColumnName((String)key);
            ColumnInfo column = (ColumnInfo)columnList.get(columnNameList.get(0));
            String uniqueName = this.getUniqueSqlParameterName(column.columnName);
            Object paramValue = this.getPassedValue(jsonQuery, (String)key);
            boolean jsonUpsertModel = false;
            if (column.isSqlJsonType() && (upsertValue = this.getUpsertValue(paramValue)) != null) {
                jsonUpsertModel = true;
                paramValue = upsertValue;
            }
            super.addParameter(uniqueName, paramValue);
            return this.buildUpdateValue(column, columnNameList.get(1), uniqueName, jsonUpsertModel);
        }).collect(Collectors.joining(","));
        if (StringExtension.IsNullOrEmpty(setString)) {
            throw new IllegalArgumentException("Please set value for update or none of parameters is valid for table " + tableName);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(tableName);
        sb.append(" SET ");
        sb.append(setString);
        sb.append(" WHERE ");
        sb.append(where);
        return sb.toString();
    }

    private String getValidColumn(HashMap<String, ColumnInfo> columnList, JSONArray array, CharSequence delimiter) {
        return StreamSupport.stream(array.spliterator(), true).filter(c -> columnList.containsKey(c)).map(c -> (String)c).collect(Collectors.joining(delimiter));
    }

    private String buildArithmeticOperation(HashMap<String, ColumnInfo> columnList, JSONArray array, String delimiter) {
        String operationString = StreamSupport.stream(array.spliterator(), true).map(c -> this.buildOperation(columnList, c)).collect(Collectors.joining(delimiter));
        return String.format(" ( %s ) ", operationString);
    }

    private String buildAggregateOperation(HashMap<String, ColumnInfo> columnList, Object aggregateObject, String operation) {
        return String.format("%s(%s)", operation, this.buildOperation(columnList, aggregateObject));
    }

    private String buildOperation(HashMap<String, ColumnInfo> columnList, Object jsonObject) {
        if (jsonObject instanceof JSONObject) {
            return this.buildFunction(columnList, (JSONObject)jsonObject);
        }
        if (jsonObject instanceof String) {
            if (columnList.containsKey(jsonObject)) {
                return (String)jsonObject;
            }
            throw new IllegalArgumentException("Invalid column " + jsonObject);
        }
        if (jsonObject instanceof Number) {
            return jsonObject.toString();
        }
        throw new IllegalArgumentException("Invalid " + jsonObject + " inside multiply function");
    }

    private String buildFieldTSQL(HashMap<String, ColumnInfo> columnList, JSONObject jsonQuery) {
        if (jsonQuery.has("*") && jsonQuery.get("*") instanceof Boolean && jsonQuery.getBoolean("*")) {
            return "*";
        }
        return columnList.values().stream().filter(c -> jsonQuery.has(c.columnName) && jsonQuery.get(c.columnName) instanceof Boolean && jsonQuery.getBoolean(c.columnName)).map(c -> c.columnName).collect(Collectors.joining(","));
    }

    private String buildAggregateTSQL(HashMap<String, ColumnInfo> columnList, JSONObject jsonQuery) {
        Iterable iterable = () -> jsonQuery.keys();
        return StreamSupport.stream(iterable.spliterator(), false).filter(key -> jsonQuery.get(key) instanceof JSONObject && $AGGREGATE_FUNCTIONS.stream().anyMatch(d -> jsonQuery.getJSONObject(key).has(d))).map(fieldName -> {
            JSONObject aggregateJsonObject = jsonQuery.getJSONObject(fieldName);
            return String.format(" %s as %s", this.buildFunction(columnList, aggregateJsonObject), fieldName);
        }).collect(Collectors.joining(","));
    }

    private String buildArithmeticTSQL(HashMap<String, ColumnInfo> columnList, JSONObject jsonQuery) {
        Iterable iterable = () -> jsonQuery.keys();
        return StreamSupport.stream(iterable.spliterator(), false).filter(key -> jsonQuery.get(key) instanceof JSONObject && $ARITHMETIC_FUNCTIONS.stream().anyMatch(d -> jsonQuery.getJSONObject(key).has(d))).map(fieldName -> {
            JSONObject aggregateJsonObject = jsonQuery.getJSONObject(fieldName);
            return String.format(" %s AS %s", this.buildFunction(columnList, aggregateJsonObject), fieldName);
        }).collect(Collectors.joining(","));
    }

    private String buildFunction(HashMap<String, ColumnInfo> columnList, JSONObject functionJsonObject) {
        String functionName;
        switch (functionName = (String)functionJsonObject.keys().next()) {
            case "$multiply": {
                return this.buildArithmeticOperation(columnList, functionJsonObject.getJSONArray(functionName), " * ");
            }
            case "$divide": {
                return this.buildArithmeticOperation(columnList, functionJsonObject.getJSONArray(functionName), " / ");
            }
            case "$plus": {
                return this.buildArithmeticOperation(columnList, functionJsonObject.getJSONArray(functionName), " + ");
            }
            case "$minus": {
                return this.buildArithmeticOperation(columnList, functionJsonObject.getJSONArray(functionName), " - ");
            }
            case "$module": {
                return this.buildArithmeticOperation(columnList, functionJsonObject.getJSONArray(functionName), " % ");
            }
            case "$sum": {
                return this.buildAggregateOperation(columnList, functionJsonObject.get(functionName), "SUM");
            }
            case "$count": {
                return this.buildAggregateOperation(columnList, functionJsonObject.get(functionName), "COUNT");
            }
            case "$min": {
                return this.buildAggregateOperation(columnList, functionJsonObject.get(functionName), "MIN");
            }
            case "$max": {
                return this.buildAggregateOperation(columnList, functionJsonObject.get(functionName), "MAX");
            }
            case "$avg": {
                return this.buildAggregateOperation(columnList, functionJsonObject.get(functionName), "AVG");
            }
        }
        throw new IllegalArgumentException(String.format("specific aggregate function %s does not support yet", functionName));
    }

    public String buildSelectTSQL(String tableName, JSONObject jsonQuery) throws Exception {
        String where;
        HashMap<String, ColumnInfo> columnList = super.getTableColumnList(tableName);
        int limit = jsonQuery.has($LIMIT) ? jsonQuery.getInt($LIMIT) : 10;
        int offset = jsonQuery.has($OFFSET) ? jsonQuery.getInt($OFFSET) : 0;
        String groups = jsonQuery.has($GROUP) ? this.getValidColumn(columnList, jsonQuery.getJSONArray($GROUP), ",") : null;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(Config.NewLine);
        String fieldQuery = this.buildFieldTSQL(columnList, jsonQuery);
        String aggregateQuery = this.buildAggregateTSQL(columnList, jsonQuery);
        String arithmeticQuery = this.buildArithmeticTSQL(columnList, jsonQuery);
        if (StringExtension.IsNullOrEmpty(fieldQuery) && StringExtension.IsNullOrEmpty(aggregateQuery) && StringExtension.IsNullOrEmpty(arithmeticQuery)) {
            sb.append("*");
        } else {
            sb.append(Stream.of(fieldQuery, aggregateQuery, arithmeticQuery).filter(c -> !StringExtension.IsNullOrEmpty(c)).collect(Collectors.joining(",")));
        }
        if (limit > 0) {
            if (this.DBType == DBTypeInfo.PostgreSQL) {
                sb.append(" ,count(1) OVER() AS ").append("__pg_total_count");
                sb.append(" ,").append(limit).append(" AS ").append("__pg_limit");
                sb.append(" ,").append(offset).append(" AS ").append("__pg_offset");
            }
            if (this.DBType == DBTypeInfo.MySql) {
                sb.append(" ,FOUND_ROWS() AS ").append("__pg_total_count");
                sb.append(" ,").append(limit).append(" AS ").append("__pg_limit");
                sb.append(" ,").append(offset).append(" AS ").append("__pg_offset");
            }
        }
        sb.append(Config.NewLine);
        sb.append(" FROM ");
        sb.append(tableName);
        if (jsonQuery.has($WHERE) && !StringExtension.IsNullOrEmpty(where = this.buildWhereTSQL(columnList, jsonQuery.getJSONObject($WHERE)))) {
            sb.append(Config.NewLine);
            sb.append(" WHERE ");
            sb.append(where);
        }
        if (!StringExtension.IsNullOrEmpty(groups)) {
            sb.append(Config.NewLine);
            sb.append(String.format(" GROUP BY %s", groups));
        }
        if (jsonQuery.has($SORT)) {
            sb.append(Config.NewLine);
            sb.append(this.buildSortTSQL(columnList, jsonQuery.getJSONObject($SORT)));
        }
        if (limit > 0) {
            sb.append(Config.NewLine);
            if (this.DBType == DBTypeInfo.PostgreSQL) {
                sb.append(" LIMIT ").append(limit);
                sb.append(" OFFSET ").append(offset);
            }
            if (this.DBType == DBTypeInfo.MySql) {
                sb.append(" LIMIT ");
                sb.append(offset).append(",");
                sb.append(limit);
            }
        }
        return sb.toString();
    }

    private List<String> getInputColumnName(String name) {
        int subQueryIndex = name.indexOf(".");
        if (subQueryIndex > 0) {
            return Arrays.asList(name.substring(0, subQueryIndex), name.substring(subQueryIndex + 1));
        }
        return Arrays.asList(name, "");
    }

    private JSONObject getQueryJSON(NameValuePair ... params) {
        JSONObject jsonQuery = new JSONObject();
        for (NameValuePair item : params) {
            jsonQuery.put(item.id, item.value);
        }
        return jsonQuery;
    }
}

