/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.DBReader;
import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.DBTypeInfo;
import LinkFuture.Core.DBHelper.Model.SPInfo;
import LinkFuture.Core.DBHelper.Model.SPParameterInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;
import LinkFuture.Init.Extensions.DateExtension;
import LinkFuture.Init.Extensions.StringExtension;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DBJsonReader
extends DBReader {
    public DBJsonReader(Statement statement, SPInfo spMetaInfo) {
        super(statement, spMetaInfo);
    }

    public JSONObject Read() throws Exception {
        JSONObject root = new JSONObject();
        if (this.DBType == DBTypeInfo.PostgreSQL && this.statement instanceof CallableStatement) {
            Connection conn = this.statement.getConnection();
            for (SPParameterInfo param : this.spMetaInfo.parameterList) {
                Statement stmt;
                ResultSet rs;
                JSONObject table;
                if (!param.isRefcursor() || (table = this.read(rs = (stmt = conn.createStatement()).executeQuery(String.format("FETCH ALL IN \"%s\"", param.parameterName)))).length() <= 0) continue;
                root.append("data", table.get("data"));
                if (!table.has("page")) continue;
                root.append("page", table.get("page"));
            }
        } else {
            boolean hadResults = true;
            while (hadResults) {
                ResultSet rs = this.statement.getResultSet();
                if (rs != null) {
                    JSONObject table = this.read(rs);
                    if (table.length() > 0) {
                        root.append("data", table.get("data"));
                        if (table.has("page")) {
                            root.append("page", table.get("page"));
                        }
                    }
                    hadResults = this.statement.getMoreResults();
                    continue;
                }
                hadResults = false;
            }
        }
        if (this.statement instanceof CallableStatement) {
            Map<String, Object> outputList = DBHelper.ReadOutputParameterList(this.spMetaInfo, (CallableStatement)this.statement, this.DBType);
            JSONObject outputParameter = new JSONObject();
            for (String key : outputList.keySet()) {
                Object output = outputList.get(key);
                if (output instanceof ResultSet) {
                    ResultSet rs = (ResultSet)output;
                    JSONObject table = this.read(rs);
                    if (table.length() <= 0) continue;
                    root.append("data", table.get("data"));
                    if (!table.has("page")) continue;
                    root.append("page", table.get("page"));
                    continue;
                }
                outputParameter.put(key, output);
            }
            if (outputParameter.length() > 0) {
                root.put("params", (Object)outputParameter);
            }
        }
        return root.length() > 0 ? root : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> postgresROW2StringList(String value) {
        if (!value.startsWith("(") || !value.endsWith(")")) {
            throw new IllegalArgumentException("postgresROW2StringList() ROW must begin with '(' and end with ')': " + value);
        }
        ArrayList<String> result = new ArrayList<String>();
        char[] c = value.toCharArray();
        StringBuilder element = new StringBuilder();
        int i = 1;
        while (c[i] != ')') {
            if (c[i] == ',') {
                if (c[i + 1] == ',') {
                    result.add("");
                } else if (c[i + 1] == ')') {
                    result.add("");
                }
                ++i;
                continue;
            }
            if (c[i] == '\"') {
                ++i;
                boolean insideQuote = true;
                while (insideQuote) {
                    char nextChar = c[i + 1];
                    if (c[i] == '\"') {
                        if (nextChar == ',' || nextChar == ')') {
                            result.add(element.toString());
                            element = new StringBuilder();
                            insideQuote = false;
                        } else {
                            if (nextChar != '\"') throw new IllegalArgumentException("postgresROW2StringList() char after \" is not valid");
                            element.append(c[++i]);
                        }
                    } else if (c[i] == '\\') {
                        if (nextChar != '\\' && nextChar != '\"') throw new IllegalArgumentException("postgresROW2StringList() char after \\ is not valid");
                        element.append(c[++i]);
                    } else {
                        element.append(c[i]);
                    }
                    ++i;
                }
                continue;
            }
            while (c[i] != ',' && c[i] != ')') {
                element.append(c[i]);
                ++i;
            }
            result.add(element.toString());
            element = new StringBuilder();
        }
        return result;
    }

    private JSONObject read(ResultSet rs) throws Exception {
        ResultSetMetaData metaData = rs.getMetaData();
        TableInfo resultMetaInfo = DBHelper.findResultsColumnInfo(metaData);
        JSONArray dataArray = new JSONArray();
        JSONObject pagerObj = new JSONObject();
        while (rs.next()) {
            JSONObject item = new JSONObject();
            for (int i = 1; i <= resultMetaInfo.columnList.size(); ++i) {
                Object itemValue = rs.getObject(i);
                if (itemValue == null) continue;
                ColumnInfo column = resultMetaInfo.columnList.get(i - 1);
                if (column.columnName.equalsIgnoreCase("__pg_limit")) {
                    pagerObj.put("limit", itemValue);
                    continue;
                }
                if (column.columnName.equalsIgnoreCase("__pg_total_count")) {
                    pagerObj.put("total_count", itemValue);
                    continue;
                }
                if (column.columnName.equalsIgnoreCase("__pg_offset")) {
                    pagerObj.put("offset", itemValue);
                    continue;
                }
                Object jsonValue = DBJsonReader.buildJSONValue(itemValue, column, this.statement.getConnection());
                item.put(column.columnName, jsonValue);
            }
            dataArray.put((Object)item);
        }
        JSONObject output = new JSONObject();
        if (dataArray.length() > 0) {
            output.put("data", (Object)dataArray);
        }
        if (pagerObj.length() > 0) {
            output.put("page", (Object)pagerObj);
        }
        return output;
    }

    private static Object buildJSONValue(Object itemValue, ColumnInfo column, Connection connection) throws Exception {
        if (column.isSqlJsonType()) {
            String jsonString = itemValue.toString().trim();
            if (jsonString.startsWith("[") && jsonString.endsWith("]")) {
                return new JSONArray(jsonString);
            }
            return new JSONObject(jsonString);
        }
        if (column.sqlType == 2003) {
            Array sqlArray = (Array)itemValue;
            String arrayString = itemValue.toString();
            arrayString = "[" + arrayString.substring(1, arrayString.length() - 1) + "]";
            JSONArray arrayJson = new JSONArray(arrayString);
            if (sqlArray.getBaseType() == 2002) {
                JSONArray structJson = new JSONArray();
                TableInfo typeInfo = DBHelper.findTypeInfo(connection, StringExtension.TrimStart(column.sqlTypeName, "_"));
                for (int j = 0; j < arrayJson.length(); ++j) {
                    String structString = arrayJson.getString(j);
                    structString = structString.substring(1, structString.length() - 1);
                    String[] list = structString.split(",");
                    JSONObject struct = new JSONObject();
                    for (int x = 0; x < typeInfo.columnList.size(); ++x) {
                        struct.put(typeInfo.columnList.get((int)x).columnName, (Object)list[x]);
                    }
                    structJson.put((Object)struct);
                }
                return structJson;
            }
            return arrayJson;
        }
        if (column.sqlType == 2002) {
            return DBJsonReader.sqlStructToJSON(itemValue.toString(), DBHelper.findTypeInfo(connection, column.sqlTypeName));
        }
        if (column.isSqlTimeStampType() && itemValue instanceof Timestamp) {
            return DateExtension.UTFFormat(DateExtension.Convert((Timestamp)itemValue));
        }
        return itemValue;
    }

    public static JSONObject sqlStructToJSON(String value, TableInfo structInfo) throws Exception {
        JSONObject output = new JSONObject();
        List<String> valueList = DBJsonReader.postgresROW2StringList(value);
        for (int i = 0; i < valueList.size(); ++i) {
            ColumnInfo column = structInfo.columnList.get(i);
            String key = StringExtension.removeQuote(column.columnName);
            String itemValue = StringExtension.removeQuote(valueList.get(i));
            if (column.isNumberType()) {
                output.put(key, (Object)NumberFormat.getNumberInstance().parse(itemValue));
            }
            if (column.sqlType == 2003) {
                String[] list;
                itemValue = itemValue.substring(1, itemValue.length() - 1);
                JSONArray array = new JSONArray();
                for (String item : list = itemValue.split(",")) {
                    if (DBHelper.numberTypes.contains(column.getArrayElementType())) {
                        array.put((Object)NumberFormat.getNumberInstance().parse(item));
                        continue;
                    }
                    array.put((Object)item);
                }
                output.put(key, (Object)array);
                continue;
            }
            output.put(key, (Object)itemValue);
        }
        return output;
    }
}

