/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.Model;

import LinkFuture.Core.ContentManager.Model.AddInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultType;
import LinkFuture.Core.ContentManager.Model.ResourceInfo;
import LinkFuture.Init.Extensions.StringExtension;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.RawSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import org.json.JSONObject;

public class ContentResultInfo {
    public String Name;
    public Exception Error;
    @JsonSerialize(using=ResultJsonSerializer.class)
    @JsonDeserialize(using=ResultJsonDeserializer.class)
    public Object Result;
    public boolean Success;
    public String Meta;
    public ContentResultType ResultType;
    public int ErrorCode;
    public long LoadTimeInMs;
    public long CachedTime;
    public long ExpiredTime;
    @JsonIgnore
    public ResourceInfo Resource;
    @JsonIgnore
    public AddInfo Add;

    public String toString() {
        return this.Result == null ? "" : this.Result.toString();
    }

    public static class ResultJsonDeserializer
    extends StdDeserializer<Object> {
        public ResultJsonDeserializer() {
            this(null);
        }

        protected ResultJsonDeserializer(Class<?> vc) {
            super(vc);
        }

        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String result = jsonParser.readValueAsTree().toString();
            if (result.startsWith("{") && result.endsWith("}")) {
                return new JSONObject(result);
            }
            return StringExtension.JsonDeQuote(result);
        }
    }

    public static class ResultJsonSerializer
    extends StdSerializer<Object> {
        private RawSerializer<String> rawSerializer = new RawSerializer(String.class);
        private ToStringSerializer stringSerializer = ToStringSerializer.instance;

        public ResultJsonSerializer() {
            this(null);
        }

        protected ResultJsonSerializer(Class<Object> t) {
            super(t);
        }

        public void serialize(Object o, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
            if (o instanceof JSONObject) {
                this.rawSerializer.serialize((Object)o.toString(), jgen, serializerProvider);
            } else {
                this.stringSerializer.serialize(o, jgen, serializerProvider);
            }
        }
    }
}

