/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentResource;

import LinkFuture.Core.ContentManager.ContentEvent.IContentEvent;
import LinkFuture.Core.ContentManager.ContentResource.IContentResource;
import LinkFuture.Core.ContentManager.ContentSelector.ContentSelectorController;
import LinkFuture.Core.ContentManager.Model.AddCycleType;
import LinkFuture.Core.ContentManager.Model.AddInfo;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultType;
import LinkFuture.Core.ContentManager.Model.ResourceInfo;
import LinkFuture.Core.ContentManager.Model.ResourceRunningInfo;
import LinkFuture.Core.ContentManager.Model.ResponseType;
import LinkFuture.Core.MemoryManager.MemoryFactory;
import LinkFuture.Core.MemoryManager.Meta.MemoryInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryMetaInfo;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;

public abstract class ContentBaseResource
implements IContentResource {
    public ResourceInfo CurrentResource;
    public AddInfo CurrentAdd;
    private String resourceIdentity;

    public ContentBaseResource(ResourceRunningInfo runningInfo) {
        this.CurrentResource = runningInfo.resource;
        this.CurrentAdd = runningInfo.add;
    }

    public abstract ContentResultInfo RetrieveResource(ContentItemInfo var1, ContentParameterCollectionInfo var2) throws Exception;

    protected ContentResultType getResponseType(ContentParameterCollectionInfo parameters) {
        if (parameters.containsKey("LF_ResponseType")) {
            ResponseType responseType = (ResponseType)((Object)parameters.get("LF_ResponseType"));
            switch (responseType) {
                case Xml: {
                    return ContentResultType.Xml;
                }
                case Json: 
                case JsonP: {
                    return ContentResultType.Json;
                }
                case Text: {
                    return ContentResultType.Text;
                }
                case Binary: {
                    return ContentResultType.Binary;
                }
                case Html: {
                    return ContentResultType.Html;
                }
            }
        }
        return ContentResultType.Json;
    }

    @Override
    public String GerResourceIdentity(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        if (StringExtension.IsNullOrEmpty(this.resourceIdentity)) {
            this.resourceIdentity = this.BuildResourceIdentity(content, parameters).replaceAll("\n", "");
            Debugger.LogFactory.trace("Generated ResourceIdentity ContentBaseResource {} => {}", (Object)this.CurrentResource.Name, (Object)this.resourceIdentity);
        }
        return this.resourceIdentity;
    }

    public abstract String BuildResourceIdentity(ContentItemInfo var1, ContentParameterCollectionInfo var2) throws Exception;

    @Override
    public abstract void Verify(ResourceInfo var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentResultInfo GerResource(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        block14: {
            ContentResultInfo result = null;
            long startTime = System.currentTimeMillis();
            try {
                ContentSelectorController.BuilderSelector(this.CurrentAdd, parameters, AddCycleType.Before);
                MemoryMetaInfo meta = MemoryFactory.findCacheMetaInfo(this.CurrentResource.CacheSettingKey);
                Object[] passArgs = new Object[]{content, parameters, this.CurrentAdd};
                if (meta == null || !meta.Enable) {
                    result = this.Callback(passArgs);
                } else {
                    meta.Key = this.GerResourceIdentity(content, parameters);
                    meta.Action = new Operation<Object>(passArgs){

                        @Override
                        public Object call() throws Exception {
                            return ContentBaseResource.this.Callback(this.params);
                        }
                    };
                    MemoryInfo memory = MemoryFactory.set(meta);
                    if (memory != null) {
                        result.CachedTime = memory.cachedTime;
                        result.ExpiredTime = memory.expiredTime;
                        result = (ContentResultInfo)memory.cachedObject;
                    }
                }
                result.Resource = this.CurrentResource;
                result.Add = this.CurrentAdd;
                if (result == null) break block14;
            }
            catch (Exception e) {
                block15: {
                    try {
                        result = new ContentResultInfo();
                        result.Name = this.CurrentResource.Name;
                        result.Success = false;
                        result.Error = e;
                        this.OnCompletedResource(this.CurrentAdd, parameters, result);
                        result.Resource = this.CurrentResource;
                        result.Add = this.CurrentAdd;
                        if (result == null) break block15;
                    }
                    catch (Throwable throwable) {
                        result.Resource = this.CurrentResource;
                        result.Add = this.CurrentAdd;
                        if (result != null) {
                            result.LoadTimeInMs = System.currentTimeMillis() - startTime;
                            if (result.Success) {
                                return result;
                            }
                            if (this.CurrentAdd != null && this.CurrentAdd.IgnoreException) {
                                return result;
                            }
                            throw result.Error;
                        }
                        throw new RuntimeException(String.format("Unexpected error on retrieve resource: %s", this.CurrentResource.Name));
                    }
                    result.LoadTimeInMs = System.currentTimeMillis() - startTime;
                    if (result.Success) {
                        return result;
                    }
                    if (this.CurrentAdd != null && this.CurrentAdd.IgnoreException) {
                        return result;
                    }
                    throw result.Error;
                }
                throw new RuntimeException(String.format("Unexpected error on retrieve resource: %s", this.CurrentResource.Name));
            }
            result.LoadTimeInMs = System.currentTimeMillis() - startTime;
            if (result.Success) {
                return result;
            }
            if (this.CurrentAdd != null && this.CurrentAdd.IgnoreException) {
                return result;
            }
            throw result.Error;
        }
        throw new RuntimeException(String.format("Unexpected error on retrieve resource: %s", this.CurrentResource.Name));
    }

    public ContentResultInfo Callback(Object ... args) throws Exception {
        ContentItemInfo content = (ContentItemInfo)args[0];
        ContentParameterCollectionInfo parameters = (ContentParameterCollectionInfo)args[1];
        AddInfo add = (AddInfo)args[2];
        ContentResultInfo result = null;
        Debugger.LogFactory.trace("Retrieve Resource: {}", (Object)this.CurrentResource.Name);
        result = this.RetrieveResource(content, parameters);
        result.Name = this.CurrentResource.Name;
        this.OnCompletedResource(add, parameters, result);
        if (result.Success) {
            return result;
        }
        throw result.Error;
    }

    private void OnCompletedResource(AddInfo add, ContentParameterCollectionInfo parameters, ContentResultInfo result) throws Exception {
        IContentEvent event;
        if (add != null && (event = add.getOnCompletedEvent()) != null) {
            Object[] context = new Object[]{result, this};
            event.OnTrigger(add, context, parameters);
        }
    }

    @Override
    public boolean MatchCondition(ContentItemInfo content, ContentParameterCollectionInfo parameters) {
        if (content != null && this.CurrentAdd != null && !StringExtension.IsNullOrEmpty(this.CurrentAdd.Condition)) {
            Boolean matched = Utility.stringExpression(parameters, this.CurrentAdd.Condition);
            Debugger.LogFactory.trace("Content {} match condition:{} = {},", new Object[]{content.Name, this.CurrentAdd.Condition, matched});
            return matched;
        }
        return true;
    }
}

