package LinkFuture.Init.ObjectExtend;

import java.util.HashMap;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 11:20 AM
 */
public class CaseInsensitiveMap<T> extends HashMap<String, T> {

    @Override
    public T put(String key, T value) {
        return super.put(key.toLowerCase(), value);
    }

    // not @Override because that would require the key parameter to be of type Object
    public T get(String key) {
        return super.get(key.toLowerCase());
    }

    public boolean containsKey(String key) {
        return super.containsKey(key.toLowerCase());
    }
}