package LinkFuture.Init;

import LinkFuture.Init.Extensions.DateExtension;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

/**
 * User: Cyokin Zhang
 * Date: 9/25/13
 * Time: 4:22 PM
 * Debugger.
 */
public class Debugger {
    public final static org.slf4j.Logger LogFactory = LoggerFactory.getLogger("LinkFuture " + Config.Version);
    public final static Marker fatalMarker = MarkerFactory.getMarker("FATAL");
    public synchronized static void fatal(String msg,Throwable ex)
    {
        LogFactory.error(fatalMarker, msg, ex);
    }
    public synchronized static void fatal(String msg)
    {
        LogFactory.error(fatalMarker,msg);
    }
    public synchronized static String getDetail(Exception ex)
    {
        StringWriter errors = new StringWriter();
        ex.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }
    public static void println(String type,String msg){
        System.out.println(String.format("[%s] [%s] [LinkFuture %s]: %s", DateExtension.Format(new Date(), "yyyy-MM-dd HH:mm:ss,SSS"),type,Config.Version,msg));
    }
}
