package LinkFuture.Init;

import LinkFuture.Init.Extensions.StringExtension;

import javax.naming.InitialContext;
import java.util.TimeZone;

/**
 * User: Cyokin Zhang
 * Date: 9/25/13
 * Time: 5:21 PM
 * don't use dynamic code here, for avoid dependency conflict.
 */
public class Config {
    public final static String DefaultTimeFormat = "yyyy-MM-dd HH:mm:ss.SSSZZZ";
    public final static String ISO8601TimeFormat = "yyyy/MM/dd'T'HH:mm:ss.SSS'Z'";
    public final static TimeZone UTCTimeZone = TimeZone.getTimeZone("UTC");
    public final static String NewLine = System.getProperty("line.separator");
    public final static String DefaultEncoding ="UTF-8";
    public final static String Empty ="";
    public final static String Version = "2.2.0";
    public final static String ClassPath = "classpath:";

    public final static String keyTotalCount= "__pg_total_count";
    public final static String keyPageLimit= "__pg_limit";
    public final static String keyPageOffset= "__pg_offset";
    public final static String FileSeparator = System.getProperty("file.separator");
    public final static int MaxParallelThread = 10;

    private static String readConfigFilePath(){
        try {
            InitialContext cxt = new InitialContext();
            return cxt.lookup("java:/comp/env/LinkFuture/config_filePath").toString();
        }
        catch (Exception e)
        {
            Debugger.LogFactory.warn("No InitialContext(java:/comp/env/LinkFuture/config_filePath) , using default file name lf.xml.");
            return "classpath:lf.xml";
        }
    }
    /***
     * read config file folder with following steps
     1) java:/comp/env/LinkFuture/config_filePath
     2) classpath:lf.xml
     */
    private static String applicationConfigurationFilePath;
    public void setConfigFilePath(String configPath){
        applicationConfigurationFilePath = configPath;
    }
    public static String getConfigFilePath(){
        if(StringExtension.IsNullOrEmpty(applicationConfigurationFilePath))
        {
            applicationConfigurationFilePath = readConfigFilePath();
        }
        return applicationConfigurationFilePath;
    }
}
