package LinkFuture.Core.MemoryManager.StaticMemoryCache;

import LinkFuture.Core.MemoryManager.IMemoryController;
import LinkFuture.Core.MemoryManager.Meta.MemoryInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryMetaInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryType;
import LinkFuture.Core.OperationManager.Operation;

/**
 * Created by Cyokin
 * on 12/16/2014.
 */
public class StaticMemoryController implements IMemoryController {
    @Override
    public <T> MemoryInfo<T> addNeverExpiredMemoryCache(String key, Operation operation) throws Exception {
        return StaticMemoryHelper.addNeverExpiredMemoryCache(key,operation);
    }

    @Override
    public <T> MemoryInfo<T> addNeverExpiredMemoryCache(String key, Object value) throws Exception {
        return StaticMemoryHelper.addNeverExpiredMemoryCache(key,new Operation() {
            @Override
            public Object call() throws Exception {
                return value;
            }
        });
    }

    @Override
    public <T> MemoryInfo<T> addMemoryCache(MemoryMetaInfo meta) throws Exception {
        return StaticMemoryHelper.addMemoryCache(meta);
    }

    @Override
    public <T> MemoryInfo<T> addMemoryCache(String key, Object value, Integer duration) throws Exception {
        MemoryMetaInfo meta = new MemoryMetaInfo();
        meta.CacheType = MemoryType.Absolute;
        meta.Key = key;
        meta.Duration = duration;
        meta.Enable = true;
        meta.Action = new Operation() {
            @Override
            public Object call() throws Exception {
                return value;
            }
        };
        return addMemoryCache(meta);
    }



    @Override
    public <T> MemoryInfo<T> getMemory(String key) {
        return StaticMemoryHelper.getMemory(key);
    }

    @Override
    public void clear(String key) {
        MemoryMetaInfo meta = new MemoryMetaInfo();
        meta.CacheType = MemoryType.Absolute;
        meta.Key = key;
        meta.Enable = true;
        StaticMemoryHelper.clear(meta);
    }

    @Override
    public void close() {
        //do nothing, as we don't need close for static local memory
    }
}
