package LinkFuture.Core.MemoryManager.Redis;

import LinkFuture.Core.MemoryManager.IMemoryController;
import LinkFuture.Core.MemoryManager.Meta.MemoryInfo;
import LinkFuture.Core.MemoryManager.Meta.MemoryMetaInfo;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Init.Debugger;

import java.net.URI;

/**
 * Created by Cyokin
 * on 11/9/2014.
 */
public class RedisMemoryController implements IMemoryController,AutoCloseable {
    private RedisHelper redisHelper;
    public RedisMemoryController(String redisServers) {
        try {
            redisHelper = new RedisHelper(new URI(redisServers));
        } catch (Exception e) {
            Debugger.fatal("RedisHelper init error",e);
            throw new RuntimeException(e.getMessage());
        }
    }
    @Override
    public <T> MemoryInfo<T> addNeverExpiredMemoryCache(String key, Operation operation) throws Exception {
        MemoryMetaInfo meta = new MemoryMetaInfo();
        meta.Key = key;
        meta.Action = operation;
        return addMemoryCache(meta);
    }

    @Override
    public <T> MemoryInfo<T> addNeverExpiredMemoryCache(String key, Object value) throws Exception {
        return addMemoryCache(key,value,null);
    }

    @Override
    public <T> MemoryInfo<T> addMemoryCache(MemoryMetaInfo meta) throws Exception {
        if(!meta.Enable)
        {
            Debugger.LogFactory.trace("this cache setting({}) has been disabled, call it directly ", meta.Key);
            MemoryInfo<T> output = new MemoryInfo<>();
            output.meta = meta;
            output.cachedObject = (T)meta.Action.call();
            return output;
        }
        MemoryInfo<T> cachedResults = redisHelper.get(meta.getUniqueKey());
        if(cachedResults!=null)
        {
            Debugger.LogFactory.trace("load memory from redis ({}) for key {}",meta.CacheType,meta.Key);
            return cachedResults;
        }
        else
        {
            Object result = meta.Action.call();
            if(meta.Duration==0)
            {
                //never expired
                cachedResults = redisHelper.set(meta.getUniqueKey(),(T)result,meta.Duration);
            }
            else
            {
                cachedResults = redisHelper.set(meta.getUniqueKey(),(T)result,meta.Duration * 60);
            }
            Debugger.LogFactory.trace("add memory into redis({}) for key {}",meta.CacheType,meta.Key);
            return cachedResults;
        }
    }

    @Override
    public <T> MemoryInfo<T> addMemoryCache(String key, Object value, Integer duration) throws Exception {
        MemoryMetaInfo meta =  new MemoryMetaInfo();
        meta.Action = new Operation() {
            @Override
            public Object call() throws Exception {
                return value;
            }
        };
        meta.Duration = duration;
        return addMemoryCache(meta);
    }

    @Override
    public <T> MemoryInfo<T> getMemory(String key) {
        MemoryMetaInfo meta = new MemoryMetaInfo();
        meta.Key = key;
        Debugger.LogFactory.trace("load memory from redis({}) for key {}",meta.CacheType,meta.Key);
        return redisHelper.get(meta.getUniqueKey());
    }

    @Override
    public void clear(String key) {
        redisHelper.del(key);
    }

    @Override
    public void close() {
        redisHelper.disconnect();
    }
}
