package LinkFuture.Core.MemoryManager.Redis;

import LinkFuture.Core.MemoryManager.Meta.MemoryInfo;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.ObjectExtend.TimeSpan;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Protocol;

import java.io.IOException;
import java.net.URI;

/**
 * Created by Cyokin on
 * 11/9/2014.
 */
public class RedisHelper {
    private static JedisPool jedisPool;
    private Jedis jedis;
    public synchronized Jedis getJedisConnection(final URI redisServersUrl,int timeout) {
        if (jedisPool == null) {
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(1000);
            config.setMaxIdle(10);
            config.setMinIdle(1);
            config.setMaxWaitMillis(30000);
            config.setTestOnBorrow(true);
            jedisPool = new JedisPool(config, redisServersUrl, timeout);
            Debugger.LogFactory.trace("Init redis pool");
        }
        return jedisPool.getResource();
    }

    /**
     * RedisHelper
     * Increase timeout if you see "Could not get a resource from the pool" exception
     * @param redisServersUrl :redis://[userName]:[password]@localhost:6380/[dbID]
     * @param timeout : ms
     */
    public RedisHelper(final URI redisServersUrl,int timeout) throws Exception {
        jedis = getJedisConnection(redisServersUrl, timeout);
    }

    /**
     * RedisHelper
     * @param redisServersUrl redis://[userName]:[password]@localhost:6380/[dbID]
     */
    public RedisHelper(URI redisServersUrl) throws Exception {
        this(redisServersUrl,Protocol.DEFAULT_TIMEOUT * 5);
    }
    public void selectDB(int dbNumber)
    {
        jedis.select(dbNumber);
    }
    public void disconnect(){
        jedis.close();
    }
    public void destory(){
        jedis.close();
        jedisPool.destroy();
    }
    public void set(String key,Object value){
        set(key,value,null);
    }
    public <T> MemoryInfo<T> set(String key, T value, Integer second){
        try {
            RedisMemoryInfo memoryInfo = new RedisMemoryInfo();
            memoryInfo.classType = value.getClass();
            memoryInfo.cachedTime = System.currentTimeMillis();
            if(second!=null) memoryInfo.expiredTime = memoryInfo.cachedTime + TimeSpan.FromSec(second).getTimeStamp();
            memoryInfo.cachedObject = (value instanceof String)?value:Utility.jacksonToJson(value);
            String passValue =  Utility.jacksonToJson(memoryInfo);
            if(second==null)
            {
                jedis.set(key,passValue);
            }
            else
            {
                jedis.setex(key,second,passValue);
            }
            return memoryInfo.getMemoryInfo(value);
        } catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
    public <T> MemoryInfo<T> get(String key)
    {
        String output = jedis.get(key);
        if(output==null) return null;
        if(output.contains("\"classType\":\""))
        {
            try {
                RedisMemoryInfo myValue = Utility.jacksonFromJson(output,RedisMemoryInfo.class);
                if(myValue.classType == String.class)
                {
                    return myValue.getMemoryInfo((T)myValue.cachedObject);
                }
                return myValue.getMemoryInfo(Utility.jacksonFromJson(myValue.cachedObject.toString(),myValue.classType));
            } catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        throw new RuntimeException("Unexpected redis value format,");
    }
    public void del(String key)
    {
        jedis.del(key);
    }


    //region ignored
    /*
    //region String
    public void set(String key,String value)
    {
        jedis.set(key,value);
    }
    public void set(String key,String value,int second)
    {
        jedis.setex(key,second,value);
    }
    public String get(String key)
    {
        return jedis.get(key);
    }
    public void del(String key)
    {
         jedis.del(key);
    }
    //endregion

    //region Object
    public void setObject(String key,Serializable value,int second)
    {
        jedis.setex(key.getBytes(), second, Utility.toByte(value));
    }
    public void setObject(String key,Serializable value)
    {
        jedis.set(key.getBytes(), Utility.toByte(value));
    }
    public<T> T getObject(String key)
    {
        return Utility.fromByte(jedis.get(key.getBytes()));
    }
    public void delObject(String key)
    {
        jedis.del(key.getBytes());
    }
    //endregion

    //region Bytes
    public void setByte(String key,byte[] value)
    {
        jedis.set(key.getBytes(), value);
    }
    public void setByte(String key,byte[] value,int second)
    {
        jedis.setex(key.getBytes(), second, value);
    }
    public byte[] getByte(String key)
    {
        return jedis.get(key.getBytes());
    }
    public void delByte(String key){
        jedis.del(key.getBytes());
    }
    //endregion
    */
    //endregion
}
