package LinkFuture.Core.MemoryManager.Meta;

import java.util.HashMap;
import java.util.Map;

/**
 * User: Cyokin Zhang
 * Date: 10/12/13
 * Time: 2:19 PM
 */
public enum MemoryType {
    Absolute(0),
    Never(1);

    private int value;
    private static final Map<Integer, MemoryType> typesByValue = new HashMap();
    static {
        for (MemoryType type : MemoryType.values()) {
            typesByValue.put(type.value, type);
        }
    }

    MemoryType(int value){
        this.value = value;
    }
    @SuppressWarnings("UnusedDeclaration")
    public int getTypeValue() {
        return this.value;
    }
    @SuppressWarnings("UnusedDeclaration")
    public static MemoryType convert(int value) {
        return typesByValue.get(value);
    }
}
