package LinkFuture.Core.MemoryManager;

import LinkFuture.Core.MemoryManager.Meta.*;
import LinkFuture.Core.MemoryManager.Redis.RedisMemoryController;
import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryController;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Core.Utility;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Init.Debugger;

/**
 * Created by Cyokin on
 * 12/16/2014.
 */
@SuppressWarnings("WeakerAccess")
public class MemoryFactory {
    public static final MemorySettingListInfo ConfigurationMeta = read();
    private static MemorySettingListInfo read() {
        try {
            return Utility.fromXml(LinkFuture.Init.Utility.getStringFromFile(ConfigurationController.AppSettings("MemoryCatchFilePath")), MemorySettingListInfo.class);
        }
        catch (Exception ex)
        {
            Debugger.LogFactory.error("Init memory setting failed",ex);
            throw new RuntimeException("Init memory setting failed, due to", ex);
        }
    }
    public static <T> MemoryInfo<T> set(String key, String value, String cacheSettingName) throws Exception {
        return set(key, new Operation() {
            @Override
            public Object call() throws Exception {
                return value;
            }
        },cacheSettingName);
    }
    public static <T> MemoryInfo<T> set(String key, Operation operation, String cacheSettingName) throws Exception {
        MemoryMetaInfo setting = findCacheMetaInfo(cacheSettingName);
        if(setting==null) throw new IllegalArgumentException("specific cache setting does not exist.");
        setting.Key = key;
        setting.Action = operation;
        return set(setting);
    }
    public static <T> MemoryInfo<T> set(MemoryMetaInfo setting) throws Exception {
        IMemoryController controller = findMemoryCacheAdapter(setting.CacheSource);
        MemoryInfo<T> output =  controller.addMemoryCache(setting);
        controller.close();
        return output;
    }

    public static MemoryMetaInfo findCacheMetaInfo(String cacheSettingName)  {
        if(ConfigurationMeta==null || !ConfigurationMeta.SettingList.containsKey(cacheSettingName))
        {
            return null;
        }
        MemorySettingInfo setting = ConfigurationMeta.SettingList.get(cacheSettingName);
        if(setting==null) return null;
        return MemoryMetaInfo.build(setting);
    }

    /**
     * get memory, no auto refresh when use redis
     * @param key
     * @param cacheSettingName
     * @param <T>
     * @return
     */
    public static  <T> MemoryInfo<T> get(String key,String cacheSettingName)    {
        MemoryMetaInfo setting = findCacheMetaInfo(cacheSettingName);
        if(setting==null) throw new IllegalArgumentException("specific cache setting does not exist.");
        if(!setting.Enable) throw new IllegalArgumentException("cache setting has been disabled, you can't get value");
        IMemoryController controller = findMemoryCacheAdapter(setting.CacheSource);
        MemoryInfo<T> output =   controller.getMemory(key);
        controller.close();
        return output;
    }

    private static IMemoryController findMemoryCacheAdapter(MemorySource source){
        switch (source)
        {
            case Redis:
                return new RedisMemoryController(ConfigurationMeta.RedisUrl);
            default:
                return new StaticMemoryController();
        }
    }
}
