package LinkFuture.Core.JsonManager;

import LinkFuture.Init.Config;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;

/**
 * User: Cyokin Zhang
 * Date: 10/23/13
 * Time: 12:19 PM
 */
public class JsonController {
    public static boolean isJsonObject(String jsonString){
        jsonString = jsonString.trim();
        return jsonString.startsWith("{") && jsonString.endsWith("}");
    }
    public static String convertJsonToXml(String jsonString)
    {
        if(jsonString.startsWith("{"))
        {
            JSONObject jsonObject=  new JSONObject(jsonString);
            return XML.toString(jsonObject);
        }
        else
        {
            JSONArray jsonObject=  new JSONArray(jsonString);
            return XML.toString(jsonObject);
        }
    }
    public static String convertXmlToJson(String xmlString,JsonOptionInfo option) {
        try(JsonObjectReader reader = new JsonObjectReader(xmlString))
        {
            JsonObjectInfo root = reader.toJsonObj();
            if(option.IgnoreRoot)
            {
                return root.toChildJson(option);
            }
            return root.toJson(option);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
    public static String convertXmlToJson(String xmlString) {
        JsonOptionInfo option = new JsonOptionInfo();
        option.AttributePrefix= Config.Empty;
        option.NamespacePrefix = Config.Empty;
        option.IgnoreNamespace = true;
        option.IgnoreRoot = false;
        option.CDataNodeName = "Content";
        option.ValueOption = JsonValueOption.AllString;
        return convertXmlToJson(xmlString,option);
    }
}
