package LinkFuture.Core.GenericRepository.Repository;

import LinkFuture.Core.ContentManager.ContentController;
import LinkFuture.Core.ContentManager.Model.*;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.NameValuePair;

import java.io.Serializable;
import java.util.ArrayList;

/*
 * Created by Cyokin
 * on 10/12/2015.
     @JsonIgnoreProperties(ignoreUnknown = true)
     @JsonInclude(JsonInclude.Include.NON_NULL)
     public class CityEntity {
         public static final String ID = "id";
         public static final String NAME = "name";
         public static final String ZONE_ID = "zone_id";
         public static final String CREATE_USER = "create_user";
         @JsonProperty(ID)
         @FieldAttribute(name = ID,isKey = true)
         public Long Id;

         @JsonProperty(NAME)
         @FieldAttribute(name = NAME)
         public String Name;

         @JsonProperty(ZONE_ID)
         @FieldAttribute(name = ZONE_ID)
         public Integer ZoneId;

         @JsonProperty(CREATE_USER)
         @FieldAttribute(name = CREATE_USER)
         public Integer CreateUser;

         @JsonFormat(shape= JsonFormat.Shape.STRING, pattern= Config.DefaultTimeFormat)
         @JsonProperty("create_time")
         @FieldAttribute(name = "create_time")
         public Date CreateTime;
     }
     Notice: make sure use Integer/Long type, instead of int/long type, as int/long is not null able type.
 */

public abstract class GenericRepository<T,ID extends Serializable> extends BaseRepository<T,ID> implements IGenericRepository<T,ID> {

    public GenericRepository(String requestPath) {
        super(requestPath);
    }

    @Override
    protected <R> Object genericDBResourceLoad(String contentName, LinkFuture.Core.WebClient.HttpMethod method, R requestObject, String cacheSetting) throws Exception{
        ArrayList<NameValuePair> list = new ArrayList<>();
        list.add(new NameValuePair(ContentController.LF_HTTP_METHOD,method));
        list.add(new NameValuePair(ContentController.LF_RESPONSE_TYPE, ResponseType.Json));
        switch (method)
        {
            case Get:
            case Delete:
                list.add(new NameValuePair(JSON_QUERY, Utility.jacksonToJson(requestObject)));
                break;
            case Post:
            case Put:
                list.add(new NameValuePair(ContentController.LF_CONTENT_TYPE, ContentType.Json));
                list.add(new NameValuePair(ContentController.LF_PLAY_LOAD, Utility.jacksonToJson(requestObject)));
                break;
            case Options:
                break;
            case Patch:
                break;
            case Head:
                break;
        }
        LoadContentInfo meta = new LoadContentInfo();
        meta.passedParam = list;
        meta.resourceOnly = false;
        meta.ignoreSecurity = true;
        if(!StringExtension.IsNullOrEmpty(cacheSetting))
        {
            meta.cacheSetting = cacheSetting;
        }
        ContentResultCollectionInfo result = ContentController.LoadContent(contentName,meta);
        if(result.size() > 0)
        {
            ContentResultInfo myResult =  result.get(0);
            if(myResult.Success)
            {
                logger.trace(myResult.Result==null?"No result found":myResult.Result.toString());
                return myResult.Result;
            }
        }
        throw new IllegalArgumentException("No result found");
    }
}
