package LinkFuture.Core.GenericRepository.EntityBuilder;

import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;
import LinkFuture.Init.Extensions.DateExtension;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Types;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Cyokin
 * on 4/8/2016.
 */
public class EntityBuilderController {
    public static void main(String args[]) throws Exception {
        writeLog("Start build entity");
        if(args.length!=6)
        {
            usage();
            System.exit(1);
        }
        HashMap<String,String> params = findParam(args);
        String connection = params.get("connection");
        String packageName = params.get("package");
        String dir = params.get("dir");
        buildEntityList(connection, packageName, dir);
        writeLog("End build entity successfully!");
    }
    private static void buildEntityList(String connection,String packageName,String dir) throws Exception {
        try(DBHelper helper = new DBHelper(connection))
        {
            Map<String,TableInfo> allTableInfo = helper.findAllTableInfo();
            Map<String,TableInfo> allTypeInfo = helper.findAllTypeInfo();
            Path entityPath = Paths.get(dir,"entity");
            if(!entityPath.toFile().exists()) entityPath.toFile().mkdir();
            for (TableInfo table : allTableInfo.values())
            {
                writeLog("build entity %s",table.name);
                buildEntity(table, packageName,entityPath.toString());
            }
            Path typePath = Paths.get(dir,"type");
            if(!typePath.toFile().exists()) typePath.toFile().mkdir();
            for (TableInfo table : allTypeInfo.values())
            {
                writeLog("build type %s",table.name);
                buildType(table, packageName,typePath.toString());
            }
        }
    }
    private static void buildType(TableInfo table,String packageName,String dir) throws FileNotFoundException {
        String className = getClassColumnName(table.name);
        File file = Paths.get(dir,className+".java").toFile();
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.printf("package %s.type;", packageName);
        printWriter.println();
        printWriter.println("/**");
        printWriter.println("* Created by LinkFuture Auto");
        printWriter.printf("* Generated on %s.", DateExtension.Format(new Date(), "MM/dd/yyyy"));printWriter.println();
        printWriter.println("*/");
        printWriter.println("@SuppressWarnings({\"unused\", \"WeakerAccess\"})");
        printWriter.printf("public enum %s {",className);printWriter.println();
        for (ColumnInfo column :table.columnList) {
            printWriter.print(column.columnName);
            printWriter.println(",");
        }
        printWriter.println("}");
        printWriter.close();
        writeLog("%s done",className);
    }
    private static void buildEntity(TableInfo table,String packageName,String dir) throws ParseException, FileNotFoundException {
        String className = getClassColumnName(table.name) + "Entity";
        File file = Paths.get(dir,className+".java").toFile();
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.printf("package %s.entity;", packageName);
        printWriter.println();
        printWriter.println("import LinkFuture.Init.Config;");
        printWriter.println("import LinkFuture.Core.GenericRepository.Entity.FieldAttribute;");
        printWriter.println("import com.fasterxml.jackson.annotation.JsonFormat;");
        printWriter.println("import com.fasterxml.jackson.annotation.JsonIgnoreProperties;");
        printWriter.println("import com.fasterxml.jackson.annotation.JsonInclude;");
        printWriter.println("import com.fasterxml.jackson.annotation.JsonProperty;");
        printWriter.println("import " + packageName + ".type.*;");
        printWriter.println("/**");
        printWriter.println("* Created by LinkFuture Auto");
        printWriter.printf("* Generated on %s.", DateExtension.Format(new Date(), "MM/dd/yyyy"));printWriter.println();
        printWriter.println("*/");
        printWriter.println("@JsonIgnoreProperties(ignoreUnknown = true)");
        printWriter.println("@JsonInclude(JsonInclude.Include.NON_NULL)");
        printWriter.println("@SuppressWarnings({\"unused\", \"WeakerAccess\"})");
        printWriter.printf("public class %s {",className);printWriter.println();
        Map<String,Integer> duplicatedColumnName = new HashMap<>();
        for (ColumnInfo column :table.columnList)
        {
            String columnName = column.columnName;

            String columnAnnotationName = columnName.toUpperCase();
            String columnPropertyName =  getJavaColumnName(columnName);
            //if have duplicated name, because of getJavaColumnName method,
            //i.e column name:  my_name VS myName all will be MyName after getJavaColumnName
            if(duplicatedColumnName.containsKey(columnPropertyName))
            {
                Integer newOrder = (duplicatedColumnName.get(columnPropertyName) + 1);
                duplicatedColumnName.put(columnPropertyName,newOrder);
                columnPropertyName = columnPropertyName + newOrder;
            }
            else
            {
                duplicatedColumnName.put(columnPropertyName,0);
            }
            printWriter.println();
            //unknown java type, you have to manually mapping by your own java class
            boolean isUnknownType = column.isUnknownJavaType() && column.sqlType != Types.STRUCT;
            if(isUnknownType) printWriter.println("/*");
            printWriter.printf("    public static final String %s = \"%s\";", columnAnnotationName,columnName);
            printWriter.println();
            printWriter.printf("    @JsonProperty(%s)", columnAnnotationName);
            printWriter.println();
            if(column.isKey)
            {
                printWriter.printf("    @FieldAttribute(name = %s,isKey = %s)", columnAnnotationName, column.isKey);
            }
            else
            {
                printWriter.printf("    @FieldAttribute(name = %s)", columnAnnotationName);
            }
            printWriter.println();
            if(column.isDateType())
            {
                printWriter.println("    @JsonFormat(shape= JsonFormat.Shape.STRING, pattern= Config.DefaultTimeFormat)");
            }
            if(column.sqlType==Types.STRUCT)
            {
                printWriter.printf("    public %s %s;", getClassColumnName(column.sqlTypeName), columnPropertyName);

            }
            else
            {
                printWriter.printf("    public %s %s;", column.getJavaClassNameBySqlType(), columnPropertyName);
            }
            printWriter.println();
            if(isUnknownType) printWriter.println("*/");
        }
        printWriter.println("}");
        printWriter.close();
        writeLog("%s.java done",className);
    }
    private static String getClassColumnName(String dbColumnName){
        StringWriter sb = new StringWriter();
        char[] chars = dbColumnName.toCharArray();
        boolean up = true;
        for (char c:chars) {
            if(c=='_')
            {
                up = true;
                continue;
            }
            if(up)
            {
                sb.append(Character.toUpperCase(c));
                up = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
    private static String getJavaColumnName(String dbColumnName)
    {
        String className = getClassColumnName(dbColumnName);
        return className.substring(0,1).toLowerCase() + className.substring(1);
    }
    private static HashMap<String,String> findParam(String args[]){
        HashMap<String,String> output = new HashMap();
        String key = null;
        for(int i=0;i<args.length; i++)
        {
            if(args[i]!=null && args[i].startsWith("--"))
            {
                key = args[i].substring(2);
            }
            else if (key!=null)
            {
                output.put(key,args[i]);
            }
        }
        return output;
    }

    private static void writeLog(String msg, Object... args){
        if(args.length>0)
        {
            System.out.println("[EntityBuilder] " + String.format(msg, args));
        }
        else
        {
            System.out.println("[EntityBuilder] " + msg);
        }
    }
    private static void writeError(String msg,Object... args){
        if(args.length>0)
        {
            System.err.println("[EntityBuilder] " + String.format(msg, args));
        }
        else
        {
            System.err.println("[EntityBuilder] " + msg);
        }
    }

    private static void usage(){
        writeError("Usage: java -jar linkfuture.envInjection.jar --connection <DB connection string> --package <Java package name> --dir <Entity file directory>");
    }
}
