package LinkFuture.Core.DBHelper.Model;

import java.util.HashMap;
import java.util.Map;

/**
 * User: Cyokin Zhang
 * Date: 9/25/13
 * Time: 5:10 PM
 */
public enum ParameterTypeInfo {
    procedureColumnUnknown(0),
    procedureColumnIn(1),
    procedureColumnInOut(2),
    procedureColumnOut(4),
    procedureColumnReturn(5),
    procedureColumnResult(3);

    private int value;
    private static final Map<Integer, ParameterTypeInfo> typesByValue = new HashMap();
    static {
        for (ParameterTypeInfo type : ParameterTypeInfo.values()) {
            typesByValue.put(type.value, type);
        }
    }

    ParameterTypeInfo(int value){
        this.value = value;
    }
    @SuppressWarnings("UnusedDeclaration")
    public int getTypeValue()
    {
        return this.value;
    }
    public static ParameterTypeInfo convert(int value) {
        return typesByValue.get(value);
    }

}