package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.Model.*;
import LinkFuture.Core.JsonManager.JsonController;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Config;
import LinkFuture.Init.Extensions.StringExtension;
import org.json.JSONArray;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.sql.*;
import java.util.ArrayList;
import java.util.Map;

/**
 * LinkFuture.
 * User: Cyokin Zhang
 * Date: 10/19/13
 * Time: 3:08 PM
 */
public class DBXmlReader extends DBReader {

    public DBXmlReader(Statement statement, SPInfo spMetaInfo) {
        super(statement, spMetaInfo);
    }
    public String Read() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element result = doc.createElement("data");
        doc.appendChild(result);
        buildXml(doc, result);
        if(this.statement instanceof CallableStatement)
        {
            Map<String,Object> outputParameterList = DBHelper.ReadOutputParameterList(this.spMetaInfo,(CallableStatement)this.statement,this.DBType);
            for (String key:outputParameterList.keySet())
            {
                Object output = outputParameterList.get(key);
                if(!(output instanceof ResultSet))
                {
                    result.setAttribute(StringExtension.XmlNodeNameEscape(key),outputParameterList.get(key).toString());
                }
            }
        }
        return Utility.xmlNodeToString(doc);
    }

    private void buildXml(Document doc, Element result) throws Exception {
        //PostgreSQL
        if(this.DBType == DBTypeInfo.PostgreSQL && this.statement instanceof CallableStatement)
        {
            Connection conn = this.statement.getConnection();
            for (SPParameterInfo param: this.spMetaInfo.parameterList)
            {
                if(param.sqlTypes == Types.OTHER)
                {
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(String.format("FETCH ALL IN \"%s\"",param.parameterName));
                    while (rs.next())
                    {
                        result.appendChild(this.read(rs,doc));
                    }
                }
            }
        }
        else
        {
            boolean hadResults = true;
            while(hadResults)
            {
                ResultSet rs = statement.getResultSet();
                result.appendChild(this.read(rs,doc));
                hadResults = statement.getMoreResults();
            }
        }
    }


    private Element read(ResultSet rs,Document doc) throws Exception {
        ResultSetMetaData metaData = rs.getMetaData();
        TableInfo resultMetaInfo = DBHelper.findResultsColumnInfo(metaData);
        Element table = doc.createElement("table");
        while (rs.next()) {
            Element row =doc.createElement("row");
            ArrayList<Element> columnList = fillObject(rs,resultMetaInfo,doc);
            for (Element node:columnList)
            {
                if(node.getTagName().equalsIgnoreCase(Config.keyPageLimit))
                {
                    table.setAttribute("limit", node.getFirstChild().getNodeValue());
                    continue;
                }
                if(node.getTagName().equalsIgnoreCase(Config.keyTotalCount))
                {
                    table.setAttribute("total_count", node.getFirstChild().getNodeValue());
                    continue;
                }
                if(node.getTagName().equalsIgnoreCase(Config.keyPageOffset))
                {
                    table.setAttribute("offset",node.getFirstChild().getNodeValue());
                    continue;
                }
                row.appendChild(node);
            }
            table.appendChild(row);
        }
        return table;
    }
    private ArrayList<Element> fillObject(ResultSet rs,TableInfo resultMetaInfo,Document doc) throws Exception {
        ArrayList<Element> list = new ArrayList<>();
        for (int i = 1; i <= resultMetaInfo.columnList.size(); i++) {
            ColumnInfo column =   resultMetaInfo.columnList.get(i -1);
            Object itemValue = rs.getObject(i);
            if(itemValue!=null)
            {
                String xmlNodeName = StringExtension.XmlNodeNameEscape(column.columnName);
                Element newNode;
                if(column.isSqlJsonType())
                {
                    itemValue = "{\""+xmlNodeName+"\":"+ itemValue + "}";
                    newNode = (Element)doc.importNode(getXmlNode(itemValue.toString()),true) ;
                }
                else if(column.sqlType == Types.ARRAY)
                {
                    String arrayString = itemValue.toString();
                    arrayString = "{\""+xmlNodeName+"\":{\"item\":"+new JSONArray("["+ arrayString.substring(1,arrayString.length()-1) + "]")+"}}";
                    newNode = (Element)doc.importNode(getXmlNode(arrayString),true) ;
                }
                else if(column.sqlType == Types.STRUCT)
                {
                    String structString = itemValue.toString();
                    structString = "{\""+xmlNodeName+"\":"+ DBJsonReader.sqlStructToJSON(structString,DBHelper.findTypeInfo(this.statement.getConnection(),column.sqlTypeName)).toString() + "}";
                    newNode = (Element)doc.importNode(getXmlNode(structString),true) ;
                }
                else
                {
                    newNode = doc.createElement(xmlNodeName);
                    newNode.appendChild(doc.createTextNode(itemValue.toString()));
                }
                list.add(newNode);
            }
        }
        return  list;
    }
    private Element getXmlNode(String jsonString) throws IOException, ParserConfigurationException, SAXException {
        String xmlString = JsonController.convertJsonToXml(jsonString);
        Document xmlDoc = Utility.parseXmlDom(xmlString);
        return  xmlDoc.getDocumentElement();
    }
}
