package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.Model.*;
import LinkFuture.Init.Config;
import LinkFuture.Init.Extensions.DateExtension;
import LinkFuture.Init.Extensions.StringExtension;
import org.json.JSONArray;
import org.json.JSONObject;

import java.sql.*;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by Cyokin
 * on 6/23/2015.
 */
public class DBJsonReader extends DBReader {
    public DBJsonReader(Statement statement, SPInfo spMetaInfo) {
        super(statement, spMetaInfo);
    }
    public JSONObject Read() throws Exception {
        JSONObject root = new JSONObject();
        //PostgreSQL
        if(this.DBType == DBTypeInfo.PostgreSQL && this.statement instanceof CallableStatement)
        {
            Connection conn = this.statement.getConnection();
            for (SPParameterInfo param: this.spMetaInfo.parameterList)
            {
                if(param.isRefcursor())
                {
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(String.format("FETCH ALL IN \"%s\"",param.parameterName));
                    JSONObject table = this.read(rs);
                    if(table.length() >0)
                    {
                        root.append("data",table.get("data"));
                        if(table.has("page")) root.append("page",table.get("page"));
                    }
                }
            }
        }
        else
        {
            boolean hadResults = true;
            while(hadResults)
            {
                ResultSet rs = statement.getResultSet();
                if(rs!=null)
                {
                    JSONObject table = this.read(rs);
                    if(table.length() >0)
                    {
                        root.append("data",table.get("data"));
                        if(table.has("page"))root.append("page",table.get("page"));
                    }

                    hadResults = statement.getMoreResults();
                }
                else
                {
                    hadResults = false;
                }
            }
        }

        if(this.statement instanceof CallableStatement)
        {
            Map<String,Object> outputList = DBHelper.ReadOutputParameterList(this.spMetaInfo,(CallableStatement)this.statement,this.DBType);
            JSONObject outputParameter = new JSONObject();
            for (String key : outputList.keySet())
            {
                Object output = outputList.get(key);
                if(output instanceof ResultSet)
                {
                    ResultSet rs = (ResultSet) output;
                    JSONObject table = this.read(rs);
                    if(table.length() >0)
                    {
                        root.append("data",table.get("data"));
                        if(table.has("page"))root.append("page",table.get("page"));
                    }
                }
                else
                {
                    outputParameter.put(key,output);
                }
            }
            if(outputParameter.length()>0)
            {
                root.put("params",outputParameter);
            }
        }
        return root.length()>0?root:null;
    }
    public static List<String> postgresROW2StringList(String value)
    {
        if (!(value.startsWith("(") && value.endsWith(")")))
            throw new IllegalArgumentException("postgresROW2StringList() ROW must begin with '(' and end with ')': " + value);

        List<String> result = new ArrayList<String>();

        char[] c = value.toCharArray();

        StringBuilder element = new StringBuilder();
        int i = 1;
        while (c[i] != ')')
        {
            if (c[i] == ',')
            {
                if (c[i+1] == ',')
                {
                    result.add("");
                } else if (c[i+1] == ')')
                {
                    result.add("");
                }
                i++;
            } else if (c[i] == '\"')
            {
                i++;
                boolean insideQuote = true;
                while(insideQuote)
                {
                    char nextChar = c[i + 1];
                    if(c[i] == '\"')
                    {
                        if (nextChar == ',' || nextChar == ')')
                        {
                            result.add(element.toString());
                            element = new StringBuilder();
                            insideQuote = false;
                        } else if(nextChar == '\"')
                        {
                            i++;
                            element.append(c[i]);
                        } else
                        {
                            throw new IllegalArgumentException("postgresROW2StringList() char after \" is not valid");
                        }
                    } else if (c[i] == '\\')
                    {
                        if(nextChar == '\\' || nextChar == '\"')
                        {
                            i++;
                            element.append(c[i]);
                        } else
                        {
                            throw new IllegalArgumentException("postgresROW2StringList() char after \\ is not valid");
                        }
                    } else
                    {
                        element.append(c[i]);
                    }
                    i++;
                }
            }else
            {
                while(!(c[i] == ',' || c[i] == ')'))
                {
                    element.append(c[i]);
                    i++;
                }
                result.add(element.toString());
                element = new StringBuilder(); // we aways loose the last object here, but its easier then checking for flag every time before append (definitely we loose some performance here)
            }
        }
        return result;
    }
    private JSONObject read(ResultSet rs) throws Exception {
        ResultSetMetaData metaData = rs.getMetaData();
        TableInfo resultMetaInfo = DBHelper.findResultsColumnInfo(metaData);
        JSONArray dataArray = new JSONArray();
        JSONObject pagerObj = new JSONObject();
        while (rs.next()) {
            JSONObject item = new JSONObject();
            for (int i = 1; i <= resultMetaInfo.columnList.size(); i++) {
                Object itemValue =  rs.getObject(i);
                if(itemValue!=null)
                {
                    ColumnInfo column =   resultMetaInfo.columnList.get(i -1);
                    //get page info
                    //TODO:hack here, need consider code structure more later
                    if(column.columnName.equalsIgnoreCase(Config.keyPageLimit))
                    {
                        pagerObj.put("limit",itemValue);
                        continue;
                    }
                    if(column.columnName.equalsIgnoreCase(Config.keyTotalCount))
                    {
                        pagerObj.put("total_count",itemValue);
                        continue;
                    }
                    if(column.columnName.equalsIgnoreCase(Config.keyPageOffset))
                    {
                        pagerObj.put("offset",itemValue);
                        continue;
                    }

                    Object jsonValue = buildJSONValue(itemValue, column,this.statement.getConnection());
                    item.put(column.columnName, jsonValue);
                }
            }
            dataArray.put(item);
        }
        JSONObject output = new JSONObject();
        if(dataArray.length()>0)output.put("data",dataArray);
        if(pagerObj.length()>0)output.put("page",pagerObj);
        return output;
    }

    private static Object buildJSONValue(Object itemValue, ColumnInfo column,Connection connection) throws Exception {
        if(column.isSqlJsonType()){
            String jsonString = itemValue.toString().trim();
            if(jsonString.startsWith("[") && jsonString.endsWith("]"))
            {
                return new JSONArray(jsonString);
            }
            else
            {
                return new JSONObject(jsonString);
            }
        }
        else if(column.sqlType == Types.ARRAY)
        {
            Array sqlArray =  (Array)itemValue;
            String arrayString = itemValue.toString();
            //remove {}
            arrayString = "["+  arrayString.substring(1, arrayString.length() - 1) + "]";
            JSONArray arrayJson = new JSONArray(arrayString);
            if(sqlArray.getBaseType()==Types.STRUCT)
            {
                JSONArray structJson = new JSONArray();
                TableInfo typeInfo = DBHelper.findTypeInfo(connection, StringExtension.TrimStart(column.sqlTypeName, "_"));
                for (int j = 0 ; j < arrayJson.length(); j++) {
                    String structString = arrayJson.getString(j);
                    //remove ()
                    structString = structString.substring(1, structString.length() - 1);
                    String[] list = structString.split(",");
                    JSONObject struct = new JSONObject();
                    for (int x=0;x<typeInfo.columnList.size();x++)
                    {
                        struct.put(typeInfo.columnList.get(x).columnName, list[x]);
                    }
                    structJson.put(struct);
                }
                return structJson;
            }
            else
            {

                return arrayJson;
            }
        }
        else if(column.sqlType == Types.STRUCT)
        {
            return sqlStructToJSON(itemValue.toString(), DBHelper.findTypeInfo(connection, column.sqlTypeName));
        }
        else if(column.isSqlTimeStampType() && itemValue instanceof Timestamp)
        {
            return DateExtension.UTFFormat(DateExtension.Convert((Timestamp) itemValue));
        }
        else
        {
            return itemValue;
        }
    }

    public static JSONObject sqlStructToJSON(String value,TableInfo structInfo) throws Exception {
        JSONObject output = new JSONObject();
        List<String> valueList = postgresROW2StringList(value);
        for (int i=0;i<valueList.size();i++)
        {
            ColumnInfo column = structInfo.columnList.get(i);
            String key = StringExtension.removeQuote(column.columnName);
            String itemValue = StringExtension.removeQuote(valueList.get(i));
            if(column.isNumberType())
            {
                output.put(key,NumberFormat.getNumberInstance().parse(itemValue));
            }
            if(column.sqlType == Types.ARRAY)
            {
                //remove start{ and end}
                itemValue = itemValue.substring(1,itemValue.length()-1);
                JSONArray array = new JSONArray();
                String[] list = itemValue.split(",");
                for (String item:list)
                {
                    if(DBHelper.numberTypes.contains(column.getArrayElementType()))
                    {
                        array.put(NumberFormat.getNumberInstance().parse(item));
                    }
                    else
                    {
                        array.put(item);
                    }
                }
                output.put(key,array);
            }
            else
            {
                output.put(key,itemValue);
            }

        }
        return output;
    }
}
