package LinkFuture.Core.ContentManager.Model;

import LinkFuture.Init.Extensions.StringExtension;

/**
 * Created by Cyokin
 * on 7/1/2015.
 */
public enum  ContentType {
    Xml("application/xml","application/xml"),
    Json("application/json","json"),
    FromURL("application/x-www-form-urlencoded","urlencoded"),
    FromMultipart("multipart/form-data","multipart"),
    Binary("application/octet-stream","stream"),
    Text("text/plain","text/plain"),
    Html("text/html","text/html");
    private String contentType;
    private String containKey;
    ContentType(String contentType,String containKey)
    {
        this.contentType = contentType;
        this.containKey = containKey;
    }
    public String getContentType() {
        return contentType;
    }
    public String getContainKey() {
        return containKey;
    }
    public static ContentType parser(String contentType)
    {
        if(StringExtension.IsNullOrEmpty(contentType))
        {
            return null;
        }
        contentType = contentType.toLowerCase();
        for (ContentType con: ContentType.class.getEnumConstants())
        {
            if(contentType.indexOf(con.getContainKey())>0)
            {
                return con;
            }
        }
        return ContentType.FromURL;
    }
}

