package LinkFuture.Core.ContentManager.Model;

import LinkFuture.Core.ActivatorsStorage;
import LinkFuture.Core.ContentManager.ContentEvent.IContentEvent;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import LinkFuture.Init.ObjectExtend.JAXBCaseInsensitiveMapAdaptor;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * User: Cyokin Zhang
 * Date: 11/20/13
 * Time: 3:12 PM
 */
@XmlRootElement(name = "Add")
@XmlSeeAlso({AddParameterInfo.class})
public class AddInfo {
    @XmlAttribute(name = "Name")
    public String Name;

    @XmlAttribute(name = "IgnoreException")
    public boolean IgnoreException;

    @XmlElement(name="SelectorList")
    @XmlJavaTypeAdapter(value=JAXBCaseInsensitiveMapAdaptor.class)
    public CaseInsensitiveMap<AddParameterInfo> SelectorList;

    @XmlAttribute(name = "OnCompleted")
    public String OnCompleted;

    @XmlAttribute(name = "Sequence")
    public int Sequence;

    @XmlAttribute(name = "Condition")
    public String Condition;

    public IContentEvent getOnCompletedEvent() throws Exception {
        if(StringExtension.IsNullOrEmpty(this.OnCompleted))
        {
            return null;
        }
        return ActivatorsStorage.GetActivator(this.OnCompleted);
    }

    @Override
    public String toString() {
        return this.Name;
    }
}
