package LinkFuture.Core.ContentManager.ContentValidator;

import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ValidatorInfo;
import LinkFuture.Init.Extensions.StringExtension;

/**
 * User: Cyokin Zhang
 * Date: 10/29/13
 * Time: 9:54 PM
 */
public abstract class ContentBeanBaseValidator <T> extends ContentBaseValidator {
    public ContentBeanBaseValidator(ContentItemInfo content, ValidatorInfo CurrentValidator,Class<T> type) throws Exception {
        super(content, CurrentValidator);
        if (this.CurrentValidator != null && !StringExtension.IsNullOrEmpty(this.CurrentValidator.Meta))
        {
            CurrentValidator.setMetaObj(type);
            this.Meta = CurrentValidator.getMetaObj();
        }
    }
    public T Meta;
}
