package LinkFuture.Core.ContentManager.ContentSelector;

import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.ObjectExtend.XsltInfo;

/**
 * User: Cyokin Zhang
 * Date: 12/3/13
 * Time: 4:36 PM
 */
public class ContentXSLTSelector extends ContentBaseSelector {
    public ContentXSLTSelector(ContentParameterCollectionInfo parameters, ContentSelectorMeta meta) {
        super(parameters, meta);
    }
    private XsltInfo ReadXslt(ContentParameterCollectionInfo parameters) throws Exception {
        String xsltPath = parameters.ParamReplace(this.meta.Key);
        return Utility.XsltReader(xsltPath);
    }
    @Override
    public Object LoadSelector() throws Exception {
        Debugger.LogFactory.trace("Load Selector: {}", this.meta.toString());
        String[] sourceList = this.meta.Source.trim().split("\\|");
        StringBuilder sb = new StringBuilder();
        sb.append("<Root>");
        for (String source :sourceList)
        {
            if(!currentParameters.containsKey(source))
            {
                throw new IllegalArgumentException("Specific source can't be found " + source);
            }
            sb.append(String.format("<Content name=\"%s\">",source));
            sb.append(currentParameters.get(source).toString());
            sb.append("</Content>");
        }
        sb.append("</Root>");
        XsltInfo xsltInfo = this.ReadXslt((ContentParameterCollectionInfo)this.currentParameters);
        return Utility.xsltTransformer(sb.toString(), xsltInfo.XsltContent, xsltInfo.XsltFilePath);
    }

    @Override
    public String BuildSelectorIdentity() throws Exception {
        return "$ContentProcessorSelector$".concat(this.meta.toString());
    }
}
