package LinkFuture.Core.ContentManager.ContentSelector;

import LinkFuture.Core.ActivatorsStorage;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;

/**
 * User: Cyokin Zhang
 * Date: 12/3/13
 * Time: 1:30 PM
 */
public class ContentSelectorMeta {
    public String Source;
    public String Key;
    public String Type;

    public IContentSelector GetSelector(ContentParameterCollectionInfo parameters) throws Exception {
        return  ActivatorsStorage.GetActivator(this.Type, parameters,this);
    }
    //{Source=$BlogFeeds , Key =/rss/channel/item/string , Type = LinkFuture.Core.ContentManager.ContentSelector.ContentXPathSelector}
    public static ContentSelectorMeta Parser(String bindingStr)
    {
          if(IsContentSelectorMeta(bindingStr))
          {
                String input = bindingStr.trim();
                //remove { and }
                ContentSelectorMeta meta = new ContentSelectorMeta();
                input = input.substring(1,input.length()-1).trim();
                String[] inputList = input.split(",");
                for(String item:inputList)
                {
                     String parameter = item.trim();
                     String[] query = parameter.split("=");
                     if(query.length!=2)
                     {
                         continue;
                     }
                     String key = query[0].trim();
                     if(key.equalsIgnoreCase("Source"))
                     {
                         meta.Source =  query[1].trim();
                         continue;
                     }
                     if(key.equalsIgnoreCase("Key"))
                     {
                         meta.Key =  query[1].trim();
                         continue;
                     }
                     if(key.equalsIgnoreCase("Type"))
                     {
                        meta.Type =  query[1].trim();
                     }
                }
                if(meta.Type==null)
                {
                    throw new IllegalArgumentException("Invalid content selector:" + bindingStr);
                }
              return meta;
          }
          return null;
    }

    public static boolean IsContentSelectorMeta(String bindingStr){
        String input = bindingStr.trim();
        return (input.startsWith("{") && input.endsWith("}") && input.split(",").length==3);
    }

    @Override
    public String toString() {
        return Source.concat(Key).concat(Type);
    }
}
