package LinkFuture.Core.ContentManager.ContentResource;


import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import LinkFuture.Core.ContentManager.Model.ContentResultType;
import LinkFuture.Core.WebClient.AuthType;
import LinkFuture.Core.WebClient.HttpMethod;
import LinkFuture.Init.ObjectExtend.JAXBCData;

import java.util.List;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */
@XmlRootElement(name ="Meta")
public class WebContentResourceMetaInfo {
    @XmlAttribute(name = "FeedUri")
    public String FeedUri;
    @XmlAttribute(name = "UserName")
    public String UserName;
    @XmlAttribute(name = "Password")
    public String Password;
    @XmlAttribute(name = "AuthType")
    public AuthType AuthType;
    @XmlAttribute(name = "HttpMethod")
    public HttpMethod Method;

    @XmlJavaTypeAdapter(value = JAXBCData.class)
    @XmlElement
    public String Payload;

    @XmlAttribute(name = "ContentType")
    public ContentResultType ContentType;

    @XmlAttribute(name = "ConnectionTimeout")
    public int ConnectionTimeout;
    @XmlAttribute(name = "ReadTimeout")
    public int ReadTimeout;

    @XmlAttribute(name = "RetryTimes")
    public int RetryTimes;

    @XmlAttribute(name = "UseCaches")
    public Boolean UseCaches;
    @XmlAttribute(name = "AutoRedirect")
    public Boolean AutoRedirect;

    @XmlElementWrapper(name="PostParameters")
    @XmlElement(name="Parameter")
    public List<WebContentResourceParameterInfo> PostParameters;
    @XmlElementWrapper(name="Headers")
    @XmlElement(name="Header")
    public List<WebContentResourceParameterInfo> Headers;
    @XmlElementWrapper(name="UrlParameters")
    @XmlElement(name="Parameter")
    public List<WebContentResourceParameterInfo> UrlParameters;
}
