package LinkFuture.Core.ContentManager;

import LinkFuture.Core.ActivatorsStorage;
import LinkFuture.Core.ContentManager.ContentAction.ContentActionInfo;
import LinkFuture.Core.ContentManager.ContentAction.ContentBaseAction;
import LinkFuture.Core.ContentManager.ContentParameter.IContentParameter;
import LinkFuture.Core.ContentManager.ContentResource.IContentResource;
import LinkFuture.Core.ContentManager.Model.*;
import LinkFuture.Core.JsonManager.JsonOptionInfo;
import LinkFuture.Core.Utility;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.PathExtension;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import LinkFuture.Init.ObjectExtend.NameValuePair;

import java.io.IOException;
import java.util.*;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */
public class ContentController {
    public final static ContentConfigurationInfo ContentConfigurationMeta = read();
    public static final String LF_RESPONSE_TYPE = "LF_ResponseType";
    public static final String LF_HTTP_METHOD = "LF_HttpMethod";
    public static final String LF_CONTENT_TYPE = "LF_ContentType";
    public static final String LF_PLAY_LOAD = "LF_PlayLoad";
    public static final String LF_APP_PATH = "LF_APPPath";

    //region LoadResource
    public static Object LoadResource(String resourceName) throws Exception {
        return LoadResource(resourceName, null);
    }
    public static Object LoadResource(String resourceName,Collection<NameValuePair> args) throws Exception {
        ArrayList<NameValuePair> inputList  = BuildParameters(args);

        ResourceInfo resource = FindResource(resourceName);
        IContentResource realAction = ActivatorsStorage.GetActivator(resource.Type, resource);
        ContentParameterCollectionInfo list = new ContentParameterCollectionInfo();
        for (NameValuePair item:inputList)
        {
            list.put(item.id,item.value);
        }
        return realAction.GerResource(null, list);
    }
    //endregion

    //region LoadContent
    public static ContentResultCollectionInfo LoadContent(String resourceName) throws Exception {
        return LoadContent(resourceName,null, new ArrayList<>());
    }
    public static ContentResultCollectionInfo LoadContent(String resourceName,Integer version) throws Exception {
        return LoadContent(resourceName,version, new ArrayList<>());
    }
    public static ContentResultCollectionInfo LoadContent(String resourceName,Collection<NameValuePair> args) throws Exception {
        return LoadContent(resourceName,null, args, false);
    }
    public static ContentResultCollectionInfo LoadContent(String resourceName,Integer version,Collection<NameValuePair> args) throws Exception {
        return LoadContent(resourceName,version, args, false);
    }
    public static ContentResultCollectionInfo LoadContent(String contentName,Integer version, Collection<NameValuePair> args, boolean resourceOnly) throws Exception {
        return LoadContent(contentName,version,args,resourceOnly,false);

    }
    public static ContentResultCollectionInfo LoadContent(String contentName,Integer version, Collection<NameValuePair> args, boolean resourceOnly,boolean ignoreSecurity) throws Exception {
        LoadContentInfo loadMeta = new LoadContentInfo();
        loadMeta.passedParam = args;
        loadMeta.resourceOnly = resourceOnly;
        loadMeta.ignoreSecurity = ignoreSecurity;
        loadMeta.version = version;
        return LoadContent(contentName,loadMeta);
    }
    public static ContentResultCollectionInfo LoadContent(String contentName,LoadContentInfo loadMeta) throws Exception {
        ArrayList<NameValuePair> inputList  = BuildParameters(loadMeta.passedParam);
        ContentActionInfo meta = new ContentActionInfo(ContentConfigurationMeta.FindContentItem(contentName,loadMeta.version),inputList);
        meta.ResourceOnly = loadMeta.resourceOnly;
        meta.IgnoreSecurity = loadMeta.ignoreSecurity;
        meta.CacheSettingProfile = loadMeta.cacheSetting;
        ContentBaseAction action = new ContentBaseAction(meta);
        return action.Action();
    }

    //endregion

    //region LoadContent for XSLT extension
    public static String LoadContent(String resourceName,String ... args) throws Exception {
        return LoadContent(resourceName,null,args);
    }
    public static String LoadContent(String resourceName,Integer version,String ... args) throws Exception {
        if(args==null || args.length==0)
        {
            ContentResultCollectionInfo result = LoadContent(resourceName,version);
            result.Params.clear();
            return result.ToContentXml();
        }
        Collection<NameValuePair> list = new ArrayList<>();
        for (int i=0;i<args.length;i=i+2)
        {
            list.add(new NameValuePair(args[i],args[i+1]));
        }
        ContentResultCollectionInfo result = LoadContent(resourceName,version, list);
        result.Params.clear();
        return result.ToContentXml();
    }
    //endregion

    //region LoadParameters
    public static CaseInsensitiveMap<Object> LoadParameters(String paramName) throws Exception {
        return LoadParameters(paramName, null);
    }
    public static CaseInsensitiveMap<Object> LoadParameters(String paramName,Collection<NameValuePair> args) throws Exception {
        if(args==null) args = new ArrayList<>();
        ParameterInfo parameter = FindParameter(paramName);
        ContentParameterCollectionInfo list = new ContentParameterCollectionInfo();
        //user param always go first
        for (NameValuePair item:args)
        {
            list.put(item.id,item.value);
        }
        IContentParameter realAction = ActivatorsStorage.GetActivator(parameter.Type, parameter);
        return realAction.GerParameter(list);
    }
    //endregion

    private static ArrayList<NameValuePair> BuildParameters(Collection<NameValuePair> args){
        //must rebuild, can't use input list directly;
        ArrayList<NameValuePair> output = new ArrayList<>();
        if(args!=null)
        {
            for (NameValuePair item :args)
            {
                output.add(item);
            }
        }
        output.add(new NameValuePair(LF_APP_PATH,PathExtension.getApplicationPath()));
        return output;
    }

    //region find
    public static ResourceInfo FindResource(String name)  {
        if(ContentConfigurationMeta.ResourceList!=null && ContentConfigurationMeta.ResourceList.containsKey(name))
        {
            return ContentConfigurationMeta.ResourceList.get(name);
        }
        throw new IllegalArgumentException("Specific resource not found:" + name);
    }
    public static ParameterInfo FindParameter(String name)  {
        if(ContentConfigurationMeta.ParameterList!=null && ContentConfigurationMeta.ParameterList.containsKey(name))
        {
            return ContentConfigurationMeta.ParameterList.get(name);
        }
        throw new IllegalArgumentException("Specific parameter not found:" + name);
    }
    //endregion
    private synchronized static void readImportFile(ContentConfigurationInfo config) throws IOException {
        if(config.ImportList!=null)
        {
            for (ContentImportFileInfo file: config.ImportList)
            {
                if(!StringExtension.IsNullOrEmpty(file.Resource))
                {
                    ContentConfigurationInfo subItem = Utility.fromXml(LinkFuture.Init.Utility.getStringFromFile(file.Resource), ContentConfigurationInfo.class);
                    //merge
                    if (subItem != null) {
                        if(subItem.ParameterList!=null)
                        {
                             if(config.ParameterList==null) config.ParameterList = new CaseInsensitiveMap<>();
                            config.ParameterList.putAll(subItem.ParameterList);
                        }
                        if(subItem.ContentItemList!=null)
                        {
                            if(config.ContentItemList==null) config.ContentItemList = new ArrayList<>();
                            //import version will overwrite inner contentitem version if null.
                            for (ContentItemInfo content:subItem.ContentItemList)
                            {
                                if(content.Version==null)
                                {
                                    content.Version = file.Version;
                                }
                            }
                            config.ContentItemList.addAll(subItem.ContentItemList);
                        }
                        if(subItem.ResourceList!=null)
                        {
                            if(config.ResourceList==null) config.ResourceList = new CaseInsensitiveMap<>();
                            config.ResourceList.putAll(subItem.ResourceList);
                        }
                        if(subItem.ProcessorList!=null)
                        {
                            if(config.ProcessorList==null) config.ProcessorList = new CaseInsensitiveMap<>();
                            config.ProcessorList.putAll(subItem.ProcessorList);
                        }
                        if(subItem.SecurityList!=null)
                        {
                            if(config.SecurityList==null) config.SecurityList = new CaseInsensitiveMap<>();
                            config.SecurityList.putAll(subItem.SecurityList);
                        }
                    }
                    readImportFile(subItem);
                }
            }
        }
    }
    private synchronized static ContentConfigurationInfo read() {
        try {
            ContentConfigurationInfo config = Utility.fromXml(LinkFuture.Init.Utility.getStringFromFile(ConfigurationController.AppSettings("ContentSettingPath")), ContentConfigurationInfo.class);
            readImportFile(config);
            //verify configuration
            if (config.SecurityList != null)
            {
                for(SecurityInfo item:config.SecurityList.values())
                {
                    if (StringExtension.IsNullOrEmpty(item.Type))
                    {
                        throw new IllegalArgumentException("Please specific processor type on:" + item.Name);
                    }
                    //active to verify type, and parse xml meta if have
                    item.getContentSecurity();
                    //ActivatorsStorage.VerifyClass(item.Type);
                }
            }
            if (config.ResourceList != null)
            {
                for(ResourceInfo item:config.ResourceList.values())
                {
                    if (StringExtension.IsNullOrEmpty(item.Type))
                    {
                        throw new IllegalArgumentException("Please specific resource type on:" + item.Name);
                    }
                    //active test and verify if the type is exist!
                    //ActivatorsStorage.VerifyClass(item.Type);
                    //active to verify type, and parse xml meta if have
                    //we can't get addinfo here
                    new ResourceRunningInfo(item,null).getContentResource();
                }
            }
            if (config.ParameterList != null)
            {
                for(ParameterInfo item:config.ParameterList.values())
                {
                    if (StringExtension.IsNullOrEmpty(item.Type))
                    {
                        throw new IllegalArgumentException("Please specific parameter type on:" + item.Name);
                    }
                    //active test and verify if the type is exist!
                    //ActivatorsStorage.VerifyClass(item.Type);
                    //active to verify type, and parse xml meta if have
                    item.getContentParameter();
                }
            }
            if (config.ProcessorList != null)
            {
                for(ProcessorInfo item:config.ProcessorList.values())
                {
                    if (StringExtension.IsNullOrEmpty(item.Type))
                    {
                        throw new IllegalArgumentException("Please specific processor type on:" + item.Name);
                    }
                    //active to verify type, and parse xml meta if have
                    new ProcessorRunningInfo(null,item,null).getContentProcessor();
                    //ActivatorsStorage.VerifyClass(item.Type);
                }
            }
            if (config.ContentItemList != null)
            {
                //duplicate version verify
                Map<String,List<Integer>> hashMap = new TreeMap<>(String.CASE_INSENSITIVE_ORDER);
                for(ContentItemInfo content:config.ContentItemList)
                {
                    if(content.Version==null)
                    {
                        content.Version = Integer.MIN_VALUE;
                    }
                    if(content.Version > config.LatestVersion)
                    {
                        config.LatestVersion = content.Version;
                    }
                    if(hashMap.containsKey(content.Name))
                    {
                        if(hashMap.get(content.Name).contains(content.Version))
                        {
                            throw new IllegalArgumentException("Specific content has duplicate version");
                        }
                        else
                        {
                            hashMap.get(content.Name).add(content.Version);
                        }
                    }
                    else
                    {
                        ArrayList<Integer> versionList = new ArrayList<>();
                        versionList.add(content.Version);
                        hashMap.put(content.Name, versionList);
                    }
                }
                Debugger.LogFactory.trace("Find latest version is {}",config.LatestVersion);

                for(ContentItemInfo content:config.ContentItemList)
                {
                    //use default json option
                    if(content.JsonOption == null)
                    {
                        content.JsonOption = new JsonOptionInfo();
                        content.JsonOption.AttributePrefix = "";
                        content.JsonOption.CDataNodeName = "Content";
                        content.JsonOption.IgnoreNamespace = true;
                    }
                    if(content.ValidatorList!=null)
                    {
                        for(ValidatorInfo validator:content.ValidatorList)
                        {
                            if (StringExtension.IsNullOrEmpty(validator.Type))
                            {
                                throw new IllegalArgumentException("Please specific validator type on:" + content.Name);
                            }
                            //active test and verify if the type is exist!
                            validator.getContentValidator(content);
                            //ActivatorsStorage.VerifyClass(validator.Type);
                        }
                    }
                    //reset resource object from config.ResourceList, and build sequence
                    if (config.ResourceList!=null && content.ResourceList!=null)
                    {
                        //find max sequence
                        int max = 0;
                        for (AddInfo add:content.ResourceList)
                        {
                             if(max < add.Sequence)
                             {
                                 max = add.Sequence;
                             }
                             if(add.SelectorList!=null)
                             {
                                 //set default cycle is Before
                                 for (AddParameterInfo selector :add.SelectorList.values())
                                 {
                                     if(selector.Cycle==null)
                                     {
                                         selector.Cycle = AddCycleType.Before;
                                     }
                                 }
                             }
                        }
                        //build temp
                        ArrayList<ResourceRunningInfo>[] cachedResourceListTemp = new ArrayList[max + 1];
                        for (AddInfo add:content.ResourceList)
                        {
                            if (!config.ResourceList.containsKey(add.Name))
                            {
                                throw new IllegalArgumentException("Specific resource type not exist:" + add.Name);
                            }
                            else
                            {
                                if(cachedResourceListTemp[add.Sequence]==null)
                                {
                                    cachedResourceListTemp[add.Sequence] = new ArrayList<>();
                                }

                                cachedResourceListTemp[add.Sequence].add(new ResourceRunningInfo(config.ResourceList.get(add.Name),add));
                            }
                        }
                        //build CachedResourceList
                        content.CachedResourceList = new ArrayList<>();
                        for (ArrayList<ResourceRunningInfo> itemList:cachedResourceListTemp)
                        {
                             if(itemList!=null)
                             {
                                 content.CachedResourceList.add(itemList);
                             }
                        }
                    }
                    //reset parameter object from config.ParameterList;
                    if (config.ParameterList!=null)
                    {
                        content.CachedParameterList = new ArrayList<>();
                        if(content.ParameterList!=null)
                        {
                            for (AddInfo add:content.ParameterList)
                            {

                                if (!config.ParameterList.containsKey(add.Name))
                                {
                                    throw new IllegalArgumentException("Specific parameter type not exist:" + add.Name);
                                }
                                else
                                {
                                    ParameterInfo myParameter = config.ParameterList.get(add.Name);
                                    //we will add global param as default,
                                    if(!myParameter.Global)
                                    {
                                        content.CachedParameterList.add(myParameter);
                                    }
                                }
                            }
                        }
                        //append global parameter
                        for (ParameterInfo globalParameter:config.ParameterList.values())
                        {
                            if(globalParameter.Global)
                            {
                                content.CachedParameterList.add(globalParameter);
                            }
                        }
                    }
                    if (config.SecurityList!=null)
                    {
                        content.CachedSecurityList= new ArrayList<>();
                        if(content.SecurityList!=null)
                        {
                            for (AddInfo add:content.SecurityList)
                            {

                                if (!config.SecurityList.containsKey(add.Name))
                                {
                                    throw new IllegalArgumentException("Specific security type not exist:" + add.Name);
                                }
                                else
                                {
                                    SecurityInfo mySecurity = config.SecurityList.get(add.Name);
                                    //we will add global param as default,
                                    if(!mySecurity.Global)
                                    {
                                        content.CachedSecurityList.add(mySecurity);
                                    }
                                }
                            }
                        }
                        //append global parameter
                        for (SecurityInfo globalSecurity:config.SecurityList.values())
                        {
                            if(globalSecurity.Global)
                            {
                                content.CachedSecurityList.add(globalSecurity);
                            }
                        }
                    }

                    if (config.ProcessorList!=null && content.ProcessorList!=null)
                    {
                        content.CachedProcessorList = new ArrayList<>();
                        for (AddInfo processor:content.ProcessorList)
                        {
                            if (!config.ProcessorList.containsKey(processor.Name))
                            {
                                throw new IllegalArgumentException("Specific processor type not exist:" + processor.Name);
                            }
                            else
                            {
                                content.CachedProcessorList.add(new ProcessorRunningInfo(content,config.ProcessorList.get(processor.Name),processor));
                            }
                        }
                    }
                }
            }
            return config;
        }
        catch (Exception ex)
        {
            Debugger.LogFactory.error("Init content manager failed",ex);
            throw new RuntimeException("Init content manager failed, due to ", ex);
        }
    }
}
