/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.MemoryManager.Redis;

import LinkFuture.Core.Singleton;
import LinkFuture.Core.Utility;
import java.io.Serializable;
import java.net.URI;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisHelper {
    private JedisPool jedisPool;
    private Jedis jedis;

    public RedisHelper(URI redisServersUrl, int timeout) throws Exception {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        this.jedisPool = Singleton.getInstance(JedisPool.class, poolConfig, redisServersUrl, timeout);
        this.jedis = this.jedisPool.getResource();
    }

    public RedisHelper(URI redisServersUrl) throws Exception {
        this(redisServersUrl, 2000);
    }

    public void selectDB(int dbNumber) {
        this.jedis.select(dbNumber);
    }

    public void disconnect() {
        this.jedis.close();
    }

    public void set(String key, String value) {
        this.jedis.set(key, value);
    }

    public void set(String key, String value, int second) {
        this.jedis.setex(key, second, value);
    }

    public String get(String key) {
        return this.jedis.get(key);
    }

    public void del(String key) {
        this.jedis.del(key);
    }

    public void setObject(String key, Serializable value, int second) {
        this.jedis.setex(key.getBytes(), second, Utility.toByte(value));
    }

    public void setObject(String key, Serializable value) {
        this.jedis.set(key.getBytes(), Utility.toByte(value));
    }

    public <T> T getObject(String key) {
        return Utility.fromByte(this.jedis.get(key.getBytes()));
    }

    public void delObject(String key) {
        this.jedis.del(key.getBytes());
    }

    public void setByte(String key, byte[] value) {
        this.jedis.set(key.getBytes(), value);
    }

    public void setByte(String key, byte[] value, int second) {
        this.jedis.setex(key.getBytes(), second, value);
    }

    public byte[] getByte(String key) {
        return this.jedis.get(key.getBytes());
    }

    public void delByte(String key) {
        this.jedis.del(key.getBytes());
    }
}

