/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.GenericRepository.Repository;

import LinkFuture.Core.GenericRepository.Entity.GenericResponse;
import LinkFuture.Core.JsonManager.JsonController;
import LinkFuture.Core.Utility;
import LinkFuture.Core.WebClient.WebClient;
import LinkFuture.Core.WebClient.WebClientResultInfo;
import LinkFuture.Core.WebClient.WebRequestInfo;
import LinkFuture.Init.Debugger;
import java.io.IOException;

public abstract class WebRequestRepository {
    private int retryTimes = 3;
    public String requestPath;

    public void setRetryTimes(int times) {
        this.retryTimes = times;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public WebRequestRepository(String requestPath) {
        this.requestPath = requestPath;
    }

    public <T> T request(WebRequestInfo meta, Class<T> parametrizedClass, Class<?> ... parameterClass) throws IOException {
        String response = this.request(meta);
        return Utility.jacksonFromJson(response, parametrizedClass, parameterClass);
    }

    public String request(WebRequestInfo meta) throws IOException {
        Debugger.LogFactory.trace("Requesting {}", (Object)meta.RequestURL);
        WebClientResultInfo result = WebClient.sendRequest(meta, this.getRetryTimes());
        if (result.success) {
            Debugger.LogFactory.trace("Request {} success", (Object)meta.RequestURL);
            return result.response;
        }
        Debugger.LogFactory.warn("Request {} failed", (Object)meta.RequestURL);
        if (result.response != null && JsonController.isJsonObject(result.response)) {
            throw new IllegalArgumentException(Utility.jacksonFromJson((String)result.response, GenericResponse.class, new Class[]{String.class}).meta.message);
        }
        throw new IllegalArgumentException(result.errorMessage);
    }
}

