/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.GenericRepository.Entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class GenericWhere
extends LinkedHashMap<String, Object> {
    private Builder builder;

    public Builder getBuilder() {
        return this.builder;
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        private HashMap<String, Object> whereMaps = new HashMap();
        private List<GenericWhere> orList = new ArrayList<GenericWhere>();

        public T and(String key, Object value) {
            this.whereMaps.put(key, value);
            return (T)this;
        }

        public T or(GenericWhere where) {
            this.orList.add(where);
            return (T)this;
        }

        public T gt(String key, final Number value) {
            this.whereMaps.put(key, new HashMap<String, Number>(){
                {
                    this.put("$gt", value);
                }
            });
            return (T)this;
        }

        public T gte(String key, final Number value) {
            this.whereMaps.put(key, new HashMap<String, Number>(){
                {
                    this.put("$gte", value);
                }
            });
            return (T)this;
        }

        public T lt(String key, final Number value) {
            this.whereMaps.put(key, new HashMap<String, Number>(){
                {
                    this.put("$lt", value);
                }
            });
            return (T)this;
        }

        public T lte(String key, final Number value) {
            this.whereMaps.put(key, new HashMap<String, Number>(){
                {
                    this.put("$lte", value);
                }
            });
            return (T)this;
        }

        public T in(String key, final Object ... values) {
            this.whereMaps.put(key, new HashMap<String, Object[]>(){
                {
                    this.put("$in", values);
                }
            });
            return (T)this;
        }

        public T like(String key, final String like) {
            this.whereMaps.put(key, new HashMap<String, String>(){
                {
                    this.put("$like", like);
                }
            });
            return (T)this;
        }

        public T between(String key, final String start, final String end) {
            this.whereMaps.put(key, new HashMap<String, Object>(){
                {
                    this.put("$between", Arrays.asList(start, end));
                }
            });
            return (T)this;
        }

        public T similar(String key, final String similar) {
            this.whereMaps.put(key, new HashMap<String, String>(){
                {
                    this.put("$similar", similar);
                }
            });
            return (T)this;
        }

        public GenericWhere build() {
            if (this.orList.size() > 0) {
                this.whereMaps.put("$or", this.orList);
            }
            GenericWhere whereInfo = new GenericWhere();
            whereInfo.builder = this;
            whereInfo.putAll(this.whereMaps);
            return whereInfo;
        }
    }
}

