/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentSelector;

import LinkFuture.Core.ContentManager.ContentSelector.ContentBaseSelector;
import LinkFuture.Core.ContentManager.ContentSelector.ContentSelectorMeta;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.Extensions.XsltExtension;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Debugger;
import org.w3c.dom.Document;

public class ContentXPathSelector
extends ContentBaseSelector {
    public ContentXPathSelector(ContentParameterCollectionInfo parameters, ContentSelectorMeta meta) {
        super(parameters, meta);
    }

    @Override
    public Object LoadSelector() throws Exception {
        if (this.currentParameters.containsKey(this.meta.Source)) {
            Debugger.LogFactory.trace("Load Selector: {}", (Object)this.meta.toString());
            Document doc = Utility.parseXmlDom(this.currentParameters.get(this.meta.Source).toString());
            return XsltExtension.XPathSelect(doc, this.meta.Key);
        }
        return null;
    }

    @Override
    public String BuildSelectorIdentity() throws Exception {
        return "$ContentXPathSelector$".concat(this.meta.toString());
    }
}

