/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentSelector;

import LinkFuture.Core.ActivatorsStorage;
import LinkFuture.Core.ContentManager.ContentSelector.IContentSelector;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;

public class ContentSelectorMeta {
    public String Source;
    public String Key;
    public String Type;

    public IContentSelector GetSelector(ContentParameterCollectionInfo parameters) throws Exception {
        return (IContentSelector)ActivatorsStorage.GetActivator(this.Type, parameters, this);
    }

    public static ContentSelectorMeta Parser(String bindingStr) {
        if (ContentSelectorMeta.IsContentSelectorMeta(bindingStr)) {
            String[] inputList;
            String input = bindingStr.trim();
            ContentSelectorMeta meta = new ContentSelectorMeta();
            input = input.substring(1, input.length() - 1).trim();
            for (String item : inputList = input.split(",")) {
                String parameter = item.trim();
                String[] query = parameter.split("=");
                if (query.length != 2) continue;
                String key = query[0].trim();
                if (key.equalsIgnoreCase("Source")) {
                    meta.Source = query[1].trim();
                    continue;
                }
                if (key.equalsIgnoreCase("Key")) {
                    meta.Key = query[1].trim();
                    continue;
                }
                if (!key.equalsIgnoreCase("Type")) continue;
                meta.Type = query[1].trim();
            }
            if (meta.Type == null) {
                throw new IllegalArgumentException("Invalid content selector:" + bindingStr);
            }
            return meta;
        }
        return null;
    }

    public static boolean IsContentSelectorMeta(String bindingStr) {
        String input = bindingStr.trim();
        return input.startsWith("{") && input.endsWith("}") && input.split(",").length == 3;
    }

    public String toString() {
        return this.Source.concat(this.Key).concat(this.Type);
    }
}

