/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentResource;

import LinkFuture.Core.ContentManager.ContentResource.ContentBeanBaseResource;
import LinkFuture.Core.ContentManager.ContentResource.DBActionInfo;
import LinkFuture.Core.ContentManager.ContentResource.DBParameterInfo;
import LinkFuture.Core.ContentManager.ContentResource.GenericDBContentResourceMetaInfo;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultType;
import LinkFuture.Core.ContentManager.Model.ResourceInfo;
import LinkFuture.Core.ContentManager.Model.ResourceRunningInfo;
import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.GenericDBHelper;
import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.CommandTypeInfo;
import LinkFuture.Core.DBHelper.Model.SPInfo;
import LinkFuture.Core.DBHelper.Model.SPParameterInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;
import LinkFuture.Core.WebClient.HttpMethod;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import javax.naming.NamingException;
import org.json.JSONArray;
import org.json.JSONObject;

public class GenericDBContentResource
extends ContentBeanBaseResource<GenericDBContentResourceMetaInfo> {
    public static final String $JSON_QUERY = "$JsonQuery";
    String DBConnectionString;

    public GenericDBContentResource(ResourceRunningInfo runningInfo) throws Exception {
        super(runningInfo, GenericDBContentResourceMetaInfo.class);
    }

    private HttpMethod getRequestMethod(ContentParameterCollectionInfo parameters) {
        if (parameters.containsKey("LF_HttpMethod")) {
            return (HttpMethod)((Object)parameters.get("LF_HttpMethod"));
        }
        return HttpMethod.Get;
    }

    private void injectDefaultParameters(JSONObject jsonQuery, DBActionInfo action) {
        if (((GenericDBContentResourceMetaInfo)this.Meta).hasDefaultParameters(action)) {
            JSONObject whereQuery;
            if (jsonQuery.has("$where")) {
                whereQuery = jsonQuery.getJSONObject("$where");
            } else {
                whereQuery = new JSONObject();
                jsonQuery.put("$where", (Object)whereQuery);
            }
            this.injectWhereDefaultParameters(whereQuery, action);
        }
    }

    private void injectWhereDefaultParameters(JSONObject whereQuery, DBActionInfo action) {
        if (((GenericDBContentResourceMetaInfo)this.Meta).hasDefaultParameters(action)) {
            for (DBParameterInfo parameter : action.DefaultParameters) {
                if (whereQuery.has(parameter.Name)) continue;
                whereQuery.put(parameter.Name, (Object)parameter.Value);
            }
        }
    }

    private JSONObject buildUpdate(ContentParameterCollectionInfo parameters, Collection<NameValuePair> sqlParams) {
        if (sqlParams.size() == 0) {
            throw new IllegalArgumentException("None of parameter is valid");
        }
        JSONObject jsonQuery = new JSONObject();
        for (NameValuePair param : sqlParams) {
            jsonQuery.put(param.id, param.value);
        }
        if (!parameters.containsKey("$where")) {
            throw new IllegalArgumentException("Where condition required");
        }
        jsonQuery.put("$where", (Object)new JSONObject((String)parameters.get("$where")));
        return jsonQuery;
    }

    private JSONObject buildDelete(ContentParameterCollectionInfo parameters, Collection<NameValuePair> sqlParams) {
        if (parameters.containsKey($JSON_QUERY)) {
            JSONObject jsonQuery = new JSONObject((String)parameters.get($JSON_QUERY));
            this.injectWhereDefaultParameters(jsonQuery, ((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction);
            return jsonQuery;
        }
        if (sqlParams.size() > 0) {
            JSONObject jsonWhere = new JSONObject();
            for (NameValuePair param : sqlParams) {
                jsonWhere.put(param.id, param.value);
            }
            return jsonWhere;
        }
        throw new IllegalArgumentException("Where condition required");
    }

    private JSONObject buildSelect(ContentParameterCollectionInfo parameters, Collection<NameValuePair> sqlParams) {
        if (parameters.containsKey($JSON_QUERY)) {
            JSONObject jsonQuery = new JSONObject((String)parameters.get($JSON_QUERY));
            this.injectDefaultParameters(jsonQuery, ((GenericDBContentResourceMetaInfo)this.Meta).SelectAction);
            return jsonQuery;
        }
        JSONObject jsonQuery = new JSONObject();
        if (parameters.containsKey("q")) {
            String[] queryFields = parameters.get("q").toString().split(",");
            for (String queryField : queryFields) {
                jsonQuery.put(queryField, true);
            }
        }
        if (sqlParams.size() > 0) {
            JSONObject jsonWhere = new JSONObject();
            for (NameValuePair param : sqlParams) {
                jsonWhere.put(param.id, param.value);
            }
            jsonQuery.put("$where", (Object)jsonWhere);
        }
        if (parameters.containsKey("$sort")) {
            jsonQuery.put("$sort", (Object)new JSONObject((String)parameters.get("$sort")));
        }
        if (parameters.containsKey("$limit")) {
            jsonQuery.put("$limit", parameters.get("$limit"));
        }
        if (parameters.containsKey("$offset")) {
            jsonQuery.put("$offset", parameters.get("$offset"));
        }
        return jsonQuery;
    }

    private JSONObject buildInsert(ContentParameterCollectionInfo parameters, Collection<NameValuePair> sqlParams) {
        if (sqlParams.size() > 0) {
            JSONObject jsonInsert = new JSONObject();
            for (NameValuePair param : sqlParams) {
                jsonInsert.put(param.id, param.value);
            }
            return jsonInsert;
        }
        throw new IllegalArgumentException("Parameter required");
    }

    @Override
    public ContentResultInfo RetrieveResource(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        try (GenericDBHelper helper = new GenericDBHelper(this.DBConnectionString);){
            HttpMethod requestMethod = this.getRequestMethod(parameters);
            ContentResultInfo result = new ContentResultInfo();
            result.Meta = ((GenericDBContentResourceMetaInfo)this.Meta).TableName;
            result.Success = true;
            result.ErrorCode = 500;
            result.ResultType = this.getResponseType(parameters);
            Collection<NameValuePair> sqlParams = this.BuildParameters(parameters);
            Debugger.LogFactory.trace("Retrieve DB resource {} with {} mode", (Object)content.Name, (Object)requestMethod);
            switch (requestMethod) {
                case Get: {
                    if (((GenericDBContentResourceMetaInfo)this.Meta).SelectAction != null && ((GenericDBContentResourceMetaInfo)this.Meta).SelectAction.Disabled) {
                        throw new IllegalArgumentException("Specific request method doesn't support! " + (Object)((Object)requestMethod));
                    }
                    JSONObject selectQuery = this.buildSelect(parameters, sqlParams);
                    if (!((GenericDBContentResourceMetaInfo)this.Meta).hasAction(((GenericDBContentResourceMetaInfo)this.Meta).SelectAction)) {
                        if (result.ResultType == ContentResultType.Json) {
                            result.Result = helper.selectToJson(((GenericDBContentResourceMetaInfo)this.Meta).TableName, selectQuery);
                            break;
                        }
                        result.Result = helper.selectToXml(((GenericDBContentResourceMetaInfo)this.Meta).TableName, selectQuery);
                        break;
                    }
                    if (parameters.containsKey($JSON_QUERY)) {
                        throw new IllegalArgumentException("We are not support generic json query when have customize action.");
                    }
                    for (NameValuePair params : sqlParams) {
                        helper.addParameter(params.id, params.value);
                    }
                    if (result.ResultType == ContentResultType.Json) {
                        result.Result = helper.executeToJson(((GenericDBContentResourceMetaInfo)this.Meta).SelectAction.Action, ((GenericDBContentResourceMetaInfo)this.Meta).SelectAction.CommandType);
                        break;
                    }
                    result.Result = helper.executeToXml(((GenericDBContentResourceMetaInfo)this.Meta).SelectAction.Action, ((GenericDBContentResourceMetaInfo)this.Meta).SelectAction.CommandType);
                    break;
                }
                case Post: {
                    if (((GenericDBContentResourceMetaInfo)this.Meta).UpdateAction != null && ((GenericDBContentResourceMetaInfo)this.Meta).UpdateAction.Disabled) {
                        throw new IllegalArgumentException("Specific request method doesn't support! " + (Object)((Object)requestMethod));
                    }
                    if (!((GenericDBContentResourceMetaInfo)this.Meta).hasAction(((GenericDBContentResourceMetaInfo)this.Meta).UpdateAction)) {
                        JSONObject updateQuery = this.buildUpdate(parameters, sqlParams);
                        result.Result = helper.update(((GenericDBContentResourceMetaInfo)this.Meta).TableName, updateQuery);
                        break;
                    }
                    for (NameValuePair params : sqlParams) {
                        helper.addParameter(params.id, params.value);
                    }
                    if (((GenericDBContentResourceMetaInfo)this.Meta).UpdateAction.CommandType == CommandTypeInfo.TSQL) {
                        result.Result = helper.executeSQL(((GenericDBContentResourceMetaInfo)this.Meta).UpdateAction.Action);
                        break;
                    }
                    if (result.ResultType == ContentResultType.Json) {
                        result.Result = helper.executeToJson(((GenericDBContentResourceMetaInfo)this.Meta).UpdateAction.Action, ((GenericDBContentResourceMetaInfo)this.Meta).UpdateAction.CommandType);
                        break;
                    }
                    result.Result = helper.executeToXml(((GenericDBContentResourceMetaInfo)this.Meta).UpdateAction.Action, ((GenericDBContentResourceMetaInfo)this.Meta).UpdateAction.CommandType);
                    break;
                }
                case Delete: {
                    if (((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction != null && ((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction.Disabled) {
                        throw new IllegalArgumentException("Specific request method doesn't support! " + (Object)((Object)requestMethod));
                    }
                    if (!((GenericDBContentResourceMetaInfo)this.Meta).hasAction(((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction)) {
                        result.Result = helper.delete(((GenericDBContentResourceMetaInfo)this.Meta).TableName, this.buildDelete(parameters, sqlParams));
                        break;
                    }
                    if (parameters.containsKey($JSON_QUERY)) {
                        throw new IllegalArgumentException("We are not support generic json query when have customize action.");
                    }
                    for (NameValuePair params : sqlParams) {
                        helper.addParameter(params.id, params.value);
                    }
                    if (((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction.CommandType == CommandTypeInfo.TSQL) {
                        result.Result = helper.executeSQL(((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction.Action);
                        break;
                    }
                    if (result.ResultType == ContentResultType.Json) {
                        result.Result = helper.executeToJson(((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction.Action, ((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction.CommandType);
                        break;
                    }
                    result.Result = helper.executeToXml(((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction.Action, ((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction.CommandType);
                    break;
                }
                case Put: {
                    if (((GenericDBContentResourceMetaInfo)this.Meta).InsertAction != null && ((GenericDBContentResourceMetaInfo)this.Meta).InsertAction.Disabled) {
                        throw new IllegalArgumentException("Specific request method doesn't support! " + (Object)((Object)requestMethod));
                    }
                    if (!((GenericDBContentResourceMetaInfo)this.Meta).hasAction(((GenericDBContentResourceMetaInfo)this.Meta).InsertAction)) {
                        String playLoad;
                        if (parameters.containsKey("LF_PlayLoad") && (playLoad = ((String)parameters.get("LF_PlayLoad")).trim()).startsWith("[") && playLoad.endsWith("]")) {
                            result.Result = new JSONObject(String.format("{\"identity\":%s}", helper.insert(((GenericDBContentResourceMetaInfo)this.Meta).TableName, new JSONArray(playLoad))));
                            break;
                        }
                        JSONObject jsonInsert = this.buildInsert(parameters, sqlParams);
                        result.Result = new JSONObject(String.format("{\"identity\":%s}", helper.insert(((GenericDBContentResourceMetaInfo)this.Meta).TableName, jsonInsert)));
                        break;
                    }
                    for (NameValuePair params : sqlParams) {
                        helper.addParameter(params.id, params.value);
                    }
                    if (((GenericDBContentResourceMetaInfo)this.Meta).InsertAction.CommandType == CommandTypeInfo.TSQL) {
                        result.Result = new JSONObject(String.format("{\"identity\":%s}", helper.insert(((GenericDBContentResourceMetaInfo)this.Meta).InsertAction.Action)));
                        break;
                    }
                    if (result.ResultType == ContentResultType.Json) {
                        result.Result = helper.executeToJson(((GenericDBContentResourceMetaInfo)this.Meta).InsertAction.Action, ((GenericDBContentResourceMetaInfo)this.Meta).InsertAction.CommandType);
                        break;
                    }
                    result.Result = helper.executeToXml(((GenericDBContentResourceMetaInfo)this.Meta).InsertAction.Action, ((GenericDBContentResourceMetaInfo)this.Meta).InsertAction.CommandType);
                    break;
                }
                case Options: {
                    result.Result = "Allow: GET(search),PUT(insert,bulk insert),POST(patch update),DELETE(delete),OPTIONS";
                    break;
                }
                case Patch: 
                case Head: {
                    throw new IllegalArgumentException("Specific request method doesn't support! " + (Object)((Object)requestMethod));
                }
            }
            result.ErrorCode = 200;
            ContentResultInfo contentResultInfo = result;
            return contentResultInfo;
        }
    }

    @Override
    public String BuildResourceIdentity(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        StringBuilder argsSb = new StringBuilder();
        argsSb.append("$GenericDBContentResource$");
        argsSb.append(this.CurrentResource.Name);
        argsSb.append("=>");
        argsSb.append(this.CurrentResource.Meta);
        argsSb.append("$ContentResultType$");
        argsSb.append((Object)this.getResponseType(parameters));
        argsSb.append("$RequestMethod$");
        argsSb.append(parameters.get("LF_HttpMethod"));
        argsSb.append("$SqlParameters$");
        Collection<NameValuePair> sqlParams = this.BuildParameters(parameters);
        for (NameValuePair param : sqlParams) {
            argsSb.append(String.format("%s:%s", param.id, param.value));
        }
        if (parameters.containsKey("q")) {
            argsSb.append(String.format("q:%s", parameters.get("q")));
        }
        if (parameters.containsKey($JSON_QUERY)) {
            argsSb.append(String.format("$JSON_QUERY:%s", parameters.get($JSON_QUERY)));
        }
        return argsSb.toString();
    }

    @Override
    public void Verify(ResourceInfo currentResource) throws Exception {
        this.DBConnectionString = ConfigurationController.AppSettings(((GenericDBContentResourceMetaInfo)this.Meta).ConnectionStringName);
        TableInfo table = DBHelper.findTableInfo(this.DBConnectionString, ((GenericDBContentResourceMetaInfo)this.Meta).TableName);
        if (table == null || table.columnList.size() == 0) {
            throw new IllegalArgumentException("Specific table name doesn't exist:" + ((GenericDBContentResourceMetaInfo)this.Meta).TableName);
        }
        if (((GenericDBContentResourceMetaInfo)this.Meta).hasAction(((GenericDBContentResourceMetaInfo)this.Meta).SelectAction) && ((GenericDBContentResourceMetaInfo)this.Meta).SelectAction.CommandType == null) {
            ((GenericDBContentResourceMetaInfo)this.Meta).SelectAction.CommandType = CommandTypeInfo.TSQL;
        }
        if (((GenericDBContentResourceMetaInfo)this.Meta).hasAction(((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction) && ((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction.CommandType == null) {
            ((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction.CommandType = CommandTypeInfo.TSQL;
        }
        if (((GenericDBContentResourceMetaInfo)this.Meta).hasAction(((GenericDBContentResourceMetaInfo)this.Meta).UpdateAction) && ((GenericDBContentResourceMetaInfo)this.Meta).UpdateAction.CommandType == null) {
            ((GenericDBContentResourceMetaInfo)this.Meta).UpdateAction.CommandType = CommandTypeInfo.TSQL;
        }
        if (((GenericDBContentResourceMetaInfo)this.Meta).hasAction(((GenericDBContentResourceMetaInfo)this.Meta).InsertAction) && ((GenericDBContentResourceMetaInfo)this.Meta).InsertAction.CommandType == null) {
            ((GenericDBContentResourceMetaInfo)this.Meta).InsertAction.CommandType = CommandTypeInfo.TSQL;
        }
    }

    public Collection<NameValuePair> BuildParameters(ContentParameterCollectionInfo parameters) throws Exception {
        TableInfo table = DBHelper.findTableInfo(this.DBConnectionString, ((GenericDBContentResourceMetaInfo)this.Meta).TableName);
        HashMap<String, NameValuePair> sqlParams = new HashMap<String, NameValuePair>();
        block5: for (ColumnInfo column : table.columnList) {
            for (String key : parameters.keySet()) {
                if (!column.sameColumnName(key)) continue;
                sqlParams.put(key, new NameValuePair(key, parameters.get(key)));
                continue block5;
            }
        }
        if (parameters.containsKey("$limit")) {
            sqlParams.put("limit", new NameValuePair("limit", parameters.get("limit")));
        }
        if (parameters.containsKey("$offset")) {
            sqlParams.put("offset", new NameValuePair("offset", parameters.get("offset")));
        }
        HttpMethod requestMethod = this.getRequestMethod(parameters);
        switch (requestMethod) {
            case Post: {
                this.appendParams(((GenericDBContentResourceMetaInfo)this.Meta).UpdateAction, parameters, sqlParams);
                break;
            }
            case Delete: {
                this.appendParams(((GenericDBContentResourceMetaInfo)this.Meta).DeleteAction, parameters, sqlParams);
                break;
            }
            case Put: {
                this.appendParams(((GenericDBContentResourceMetaInfo)this.Meta).InsertAction, parameters, sqlParams);
                break;
            }
            default: {
                this.appendParams(((GenericDBContentResourceMetaInfo)this.Meta).SelectAction, parameters, sqlParams);
            }
        }
        return sqlParams.values();
    }

    private void appendParams(DBActionInfo action, ContentParameterCollectionInfo parameters, HashMap<String, NameValuePair> sqlParams) throws SQLException, ClassNotFoundException, IOException, NamingException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        block3: {
            block2: {
                if (!((GenericDBContentResourceMetaInfo)this.Meta).hasAction(action)) break block2;
                SPInfo meta = DBHelper.findSPMetaInfo(this.DBConnectionString, action.Action, action.CommandType);
                for (SPParameterInfo parameter : meta.parameterList) {
                    if (!parameters.containsKey(parameter.parameterName)) continue;
                    sqlParams.put(parameter.parameterName.toLowerCase(), new NameValuePair(parameter.parameterName, parameters.get(parameter.parameterName)));
                }
                break block3;
            }
            if (!((GenericDBContentResourceMetaInfo)this.Meta).hasDefaultParameters(action)) break block3;
            for (DBParameterInfo parameter : action.DefaultParameters) {
                sqlParams.put(parameter.Name.toLowerCase(), new NameValuePair(parameter.Name, parameters.ParamReplace(parameter.Value)));
            }
        }
    }
}

