/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentAction;

import LinkFuture.Core.ContentManager.ContentParameter.IContentParameter;
import LinkFuture.Core.ContentManager.ContentProcessor.IContentProcessor;
import LinkFuture.Core.ContentManager.ContentResource.IContentResource;
import LinkFuture.Core.ContentManager.ContentSecurity.IContentSecurity;
import LinkFuture.Core.ContentManager.ContentValidator.IContentValidator;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ParameterInfo;
import LinkFuture.Core.ContentManager.Model.ProcessorRunningInfo;
import LinkFuture.Core.ContentManager.Model.ResourceRunningInfo;
import LinkFuture.Core.ContentManager.Model.SecurityInfo;
import LinkFuture.Core.ContentManager.Model.ValidatorInfo;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import java.util.ArrayList;
import java.util.Collection;

public class ContentActionInfo {
    public ContentItemInfo ContentItem;
    public Collection<NameValuePair> ParamList;
    public ArrayList<IContentSecurity> SecurityList = new ArrayList();
    public ArrayList<IContentValidator> ValidatorList = new ArrayList();
    public ArrayList<IContentParameter> ParameterList = new ArrayList();
    public ArrayList<IContentProcessor> ProcessorList = new ArrayList();
    public ArrayList<ArrayList<IContentResource>> ResourceList = new ArrayList();
    public boolean ResourceOnly;
    public boolean IgnoreSecurity;

    public ContentActionInfo(ContentItemInfo contentItem, Collection<NameValuePair> args) {
        this.ContentItem = contentItem;
        this.ParamList = args;
        this.Init();
    }

    public String IdentityKey(ContentParameterCollectionInfo parameters) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("$CL_ContentItem$");
        sb.append(this.ContentItem.Name);
        sb.append("_");
        sb.append(this.ContentItem.CacheSettingKey);
        sb.append("_");
        sb.append(this.ContentItem.OutputCacheProfileKey);
        sb.append("_");
        sb.append("$ResourceIdentity$");
        for (ArrayList<IContentResource> resourcesList : this.ResourceList) {
            for (IContentResource resource : resourcesList) {
                sb.append(resource.GerResourceIdentity(this.ContentItem, parameters));
                sb.append("_");
            }
        }
        if (this.ProcessorList.size() > 0) {
            sb.append("$ProcessorIdentity$");
            for (IContentProcessor processor : this.ProcessorList) {
                sb.append(processor.GerProcessorIdentity(parameters));
                sb.append("_");
            }
        }
        sb.append("__END");
        return sb.toString();
    }

    public ContentParameterCollectionInfo BuildContentParameter() throws Exception {
        ContentParameterCollectionInfo list = new ContentParameterCollectionInfo();
        if (this.ParamList != null) {
            for (NameValuePair nameValuePair : this.ParamList) {
                list.put(nameValuePair.id, nameValuePair.value);
            }
        }
        for (IContentParameter iContentParameter : this.ParameterList) {
            CaseInsensitiveMap<Object> parameterList = iContentParameter.GerParameter(list);
            for (String paramKey : parameterList.keySet()) {
                list.put(paramKey, parameterList.get(paramKey));
            }
        }
        return list;
    }

    private void Init() {
        try {
            if (this.ContentItem.CachedSecurityList != null) {
                for (SecurityInfo securityInfo : this.ContentItem.CachedSecurityList) {
                    this.SecurityList.add(securityInfo.getContentSecurity());
                }
            }
            if (this.ContentItem.CachedParameterList != null) {
                for (ParameterInfo parameterInfo : this.ContentItem.CachedParameterList) {
                    this.ParameterList.add(parameterInfo.getContentParameter());
                }
            }
            if (this.ContentItem.ValidatorList != null) {
                for (ValidatorInfo validatorInfo : this.ContentItem.ValidatorList) {
                    this.ValidatorList.add(validatorInfo.getContentValidator(this.ContentItem));
                }
            }
            if (this.ContentItem.CachedResourceList != null) {
                for (ArrayList arrayList : this.ContentItem.CachedResourceList) {
                    ArrayList<IContentResource> contentResourcesList = new ArrayList<IContentResource>();
                    for (ResourceRunningInfo item : arrayList) {
                        contentResourcesList.add(item.getContentResource());
                    }
                    this.ResourceList.add(contentResourcesList);
                }
            }
            if (this.ContentItem.CachedProcessorList != null) {
                for (ProcessorRunningInfo processorRunningInfo : this.ContentItem.CachedProcessorList) {
                    this.ProcessorList.add(processorRunningInfo.getContentProcessor());
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

